/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.darpc;

import com.ibm.darpc.DaRPCClientEndpoint;
import com.ibm.darpc.DaRPCMessage;
import com.ibm.darpc.DaRPCStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaRPCFuture<R extends DaRPCMessage, T extends DaRPCMessage>
implements Future<T> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.ibm.darpc");
    protected static int RPC_PENDING = 0;
    protected static int RPC_DONE = 1;
    protected static int RPC_ERROR = 2;
    private int ticket;
    private R request;
    private T response;
    private DaRPCStream<R, T> stream;
    private DaRPCClientEndpoint<R, T> endpoint;
    private boolean streamLogged;
    private AtomicInteger status;
    private AtomicInteger recvStatus;

    public DaRPCFuture(DaRPCStream<R, T> stream, DaRPCClientEndpoint<R, T> endpoint, R request, T response, boolean streamLogged) {
        this.request = request;
        this.response = response;
        this.ticket = -1;
        this.stream = stream;
        this.endpoint = endpoint;
        this.status = new AtomicInteger(RPC_PENDING);
        this.streamLogged = streamLogged;
        this.recvStatus = new AtomicInteger(0);
    }

    public int getTicket() {
        return this.ticket;
    }

    public R getSendMessage() {
        return this.request;
    }

    public T getReceiveMessage() {
        return this.response;
    }

    public void stamp(int ticket) {
        this.ticket = ticket;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        if (this.status.get() == RPC_PENDING) {
            try {
                this.endpoint.pollUntil(this.status, Long.MAX_VALUE);
            }
            catch (Exception e) {
                this.status.set(RPC_ERROR);
                throw new InterruptedException(e.getMessage());
            }
        }
        if (this.status.get() == RPC_DONE) {
            return this.getReceiveMessage();
        }
        if (this.status.get() == RPC_PENDING) {
            throw new InterruptedException("RPC timeout");
        }
        throw new InterruptedException("RPC error");
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException {
        if (this.status.get() == RPC_PENDING) {
            try {
                this.endpoint.pollUntil(this.status, timeout);
            }
            catch (Exception e) {
                this.status.set(RPC_ERROR);
                throw new InterruptedException(e.getMessage());
            }
        }
        if (this.status.get() == RPC_DONE) {
            return this.getReceiveMessage();
        }
        if (this.status.get() == RPC_PENDING) {
            throw new InterruptedException("RPC timeout");
        }
        throw new InterruptedException("RPC error");
    }

    @Override
    public boolean isDone() {
        if (this.status.get() == 0) {
            try {
                this.endpoint.pollOnce();
            }
            catch (Exception e) {
                this.status.set(RPC_ERROR);
                logger.info(e.getMessage());
            }
        }
        return this.status.get() > 0;
    }

    public synchronized void signal(int wcstatus) {
        if (this.status.get() == 0) {
            if (wcstatus == 0) {
                this.status.set(RPC_DONE);
            } else {
                this.status.set(RPC_ERROR);
            }
            if (this.streamLogged) {
                this.stream.addFuture(this);
            }
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    public boolean isStreamLogged() {
        return this.streamLogged;
    }

    public boolean touch() {
        if (this.recvStatus.incrementAndGet() == 2) {
            this.recvStatus.set(0);
            return true;
        }
        return false;
    }
}

