/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.darpc;

import com.ibm.darpc.DaRPCEndpoint;
import com.ibm.darpc.DaRPCMessage;
import com.ibm.darpc.DaRPCProtocol;
import com.ibm.disni.RdmaEndpointGroup;
import com.ibm.disni.verbs.IbvCQ;
import com.ibm.disni.verbs.IbvPd;
import com.ibm.disni.verbs.IbvQP;
import com.ibm.disni.verbs.IbvQPInitAttr;
import com.ibm.disni.verbs.RdmaCmId;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DaRPCEndpointGroup<E extends DaRPCEndpoint<R, T>, R extends DaRPCMessage, T extends DaRPCMessage>
extends RdmaEndpointGroup<E> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.ibm.darpc");
    private static int DARPC_VERSION = 50;
    private int recvQueueSize;
    private int sendQueueSize;
    private int timeout;
    private int bufferSize;
    private int maxInline;

    public static int getVersion() {
        return DARPC_VERSION;
    }

    protected DaRPCEndpointGroup(DaRPCProtocol<R, T> protocol, int timeout, int maxinline, int recvQueue, int sendQueue) throws Exception {
        super(timeout);
        this.recvQueueSize = recvQueue;
        this.sendQueueSize = Math.max(recvQueue, sendQueue);
        this.timeout = timeout;
        this.bufferSize = Math.max(protocol.createRequest().size(), protocol.createResponse().size());
        this.maxInline = maxinline;
    }

    protected synchronized IbvQP createQP(RdmaCmId id, IbvPd pd, IbvCQ cq) throws IOException {
        IbvQPInitAttr attr = new IbvQPInitAttr();
        attr.cap().setMax_recv_wr(this.recvQueueSize);
        attr.cap().setMax_send_wr(this.sendQueueSize);
        attr.cap().setMax_recv_sge(1);
        attr.cap().setMax_send_sge(1);
        attr.cap().setMax_inline_data(this.maxInline);
        attr.setQp_type((byte)2);
        attr.setRecv_cq(cq);
        attr.setSend_cq(cq);
        IbvQP qp = id.createQP(pd, attr);
        return qp;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void close() throws IOException, InterruptedException {
        super.close();
        logger.info("rpc group down");
    }

    public int recvQueueSize() {
        return this.recvQueueSize;
    }

    public int sendQueueSize() {
        return this.sendQueueSize;
    }

    public int getMaxInline() {
        return this.maxInline;
    }
}

