/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.darpc;

import com.ibm.darpc.DaRPCEndpointGroup;
import com.ibm.darpc.DaRPCMessage;
import com.ibm.disni.RdmaEndpoint;
import com.ibm.disni.util.MemoryUtils;
import com.ibm.disni.verbs.IbvMr;
import com.ibm.disni.verbs.IbvRecvWR;
import com.ibm.disni.verbs.IbvSendWR;
import com.ibm.disni.verbs.IbvSge;
import com.ibm.disni.verbs.IbvWC;
import com.ibm.disni.verbs.RdmaCmId;
import com.ibm.disni.verbs.SVCPostRecv;
import com.ibm.disni.verbs.SVCPostSend;
import com.ibm.disni.verbs.SVCRegMr;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DaRPCEndpoint<R extends DaRPCMessage, T extends DaRPCMessage>
extends RdmaEndpoint {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.ibm.darpc");
    private static final int headerSize = 4;
    private DaRPCEndpointGroup<? extends DaRPCEndpoint<R, T>, R, T> rpcGroup;
    private ByteBuffer dataBuffer;
    private IbvMr dataMr;
    private ByteBuffer receiveBuffer;
    private ByteBuffer sendBuffer;
    private ByteBuffer[] recvBufs;
    private ByteBuffer[] sendBufs;
    private SVCPostRecv[] recvCall;
    private SVCPostSend[] sendCall;
    private ConcurrentHashMap<Integer, SVCPostSend> pendingPostSend;
    private ArrayBlockingQueue<SVCPostSend> freePostSend;
    private AtomicLong ticketCount;
    private int pipelineLength;
    private int payloadSize;
    private int rawBufferSize;
    private int maxinline;
    private AtomicLong messagesSent;
    private AtomicLong messagesReceived;

    public abstract void dispatchReceive(ByteBuffer var1, int var2, int var3) throws IOException;

    public abstract void dispatchSend(int var1) throws IOException;

    public DaRPCEndpoint(DaRPCEndpointGroup<? extends DaRPCEndpoint<R, T>, R, T> endpointGroup, RdmaCmId idPriv, boolean serverSide) throws IOException {
        super(endpointGroup, idPriv, serverSide);
        this.rpcGroup = endpointGroup;
        this.maxinline = this.rpcGroup.getMaxInline();
        this.payloadSize = this.rpcGroup.getBufferSize();
        this.rawBufferSize = 4 + this.payloadSize;
        this.pipelineLength = this.rpcGroup.recvQueueSize();
        this.freePostSend = new ArrayBlockingQueue(this.pipelineLength);
        this.pendingPostSend = new ConcurrentHashMap();
        this.recvBufs = new ByteBuffer[this.pipelineLength];
        this.sendBufs = new ByteBuffer[this.pipelineLength];
        this.recvCall = new SVCPostRecv[this.pipelineLength];
        this.sendCall = new SVCPostSend[this.pipelineLength];
        this.ticketCount = new AtomicLong(0L);
        this.messagesSent = new AtomicLong(0L);
        this.messagesReceived = new AtomicLong(0L);
        logger.info("RPC client endpoint, with payload buffer size = " + this.payloadSize + ", pipeline " + this.pipelineLength);
    }

    public void init() throws IOException {
        int sendBufferOffset = this.pipelineLength * this.rawBufferSize;
        this.dataBuffer = ByteBuffer.allocateDirect(this.pipelineLength * this.rawBufferSize * 2);
        this.dataMr = ((SVCRegMr)((SVCRegMr)this.registerMemory(this.dataBuffer).execute()).free()).getMr();
        this.dataBuffer.limit(this.dataBuffer.position() + sendBufferOffset);
        this.receiveBuffer = this.dataBuffer.slice();
        this.dataBuffer.position(sendBufferOffset);
        this.dataBuffer.limit(this.dataBuffer.position() + sendBufferOffset);
        this.sendBuffer = this.dataBuffer.slice();
        for (int i = 0; i < this.pipelineLength; ++i) {
            this.receiveBuffer.position(i * this.rawBufferSize);
            this.receiveBuffer.limit(this.receiveBuffer.position() + this.rawBufferSize);
            this.recvBufs[i] = this.receiveBuffer.slice();
            this.sendBuffer.position(i * this.rawBufferSize);
            this.sendBuffer.limit(this.sendBuffer.position() + this.rawBufferSize);
            this.sendBufs[i] = this.sendBuffer.slice();
            this.recvCall[i] = this.setupRecvTask(i);
            this.sendCall[i] = this.setupSendTask(i);
            this.freePostSend.add(this.sendCall[i]);
            this.recvCall[i].execute();
        }
    }

    public synchronized void close() throws IOException, InterruptedException {
        super.close();
        this.deregisterMemory(this.dataMr);
    }

    public long getMessagesSent() {
        return this.messagesSent.get();
    }

    public long getMessagesReceived() {
        return this.messagesReceived.get();
    }

    protected boolean sendMessage(DaRPCMessage message, int ticket) throws IOException {
        SVCPostSend postSend = this.freePostSend.poll();
        if (postSend != null) {
            int index = (int)postSend.getWrMod(0).getWr_id();
            this.sendBufs[index].putInt(0, ticket);
            this.sendBufs[index].position(4);
            int written = 4 + message.write(this.sendBufs[index]);
            postSend.getWrMod(0).getSgeMod(0).setLength(written);
            postSend.getWrMod(0).setSend_flags(IbvSendWR.IBV_SEND_SIGNALED);
            if (written <= this.maxinline) {
                postSend.getWrMod(0).setSend_flags(postSend.getWrMod(0).getSend_flags() | IbvSendWR.IBV_SEND_INLINE);
            }
            this.pendingPostSend.put(ticket, postSend);
            postSend.execute();
            this.messagesSent.incrementAndGet();
            return true;
        }
        return false;
    }

    protected void postRecv(int index) throws IOException {
        this.recvCall[index].execute();
    }

    public void freeSend(int ticket) throws IOException {
        SVCPostSend sendOperation = this.pendingPostSend.remove(ticket);
        if (sendOperation == null) {
            throw new IOException("no pending ticket " + ticket + ", current ticket count " + this.ticketCount.get());
        }
        this.freePostSend.add(sendOperation);
    }

    public void dispatchCqEvent(IbvWC wc) throws IOException {
        if (wc.getStatus() == 5) {
            return;
        }
        if (wc.getStatus() != 0) {
            throw new IOException("Faulty operation! wc.status " + wc.getStatus());
        }
        if (wc.getOpcode() == 128) {
            int index = (int)wc.getWr_id();
            ByteBuffer recvBuffer = this.recvBufs[index];
            int ticket = recvBuffer.getInt(0);
            recvBuffer.position(4);
            this.dispatchReceive(recvBuffer, ticket, index);
        } else if (wc.getOpcode() == 0) {
            int index = (int)wc.getWr_id();
            ByteBuffer sendBuffer = this.sendBufs[index];
            int ticket = sendBuffer.getInt(0);
            this.dispatchSend(ticket);
        } else {
            throw new IOException("Unkown opcode " + wc.getOpcode());
        }
    }

    private SVCPostSend setupSendTask(int wrid) throws IOException {
        ArrayList<IbvSendWR> sendWRs = new ArrayList<IbvSendWR>(1);
        LinkedList<IbvSge> sgeList = new LinkedList<IbvSge>();
        IbvSge sge = new IbvSge();
        sge.setAddr(MemoryUtils.getAddress((ByteBuffer)this.sendBufs[wrid]));
        sge.setLength(this.rawBufferSize);
        sge.setLkey(this.dataMr.getLkey());
        sgeList.add(sge);
        IbvSendWR sendWR = new IbvSendWR();
        sendWR.setSg_list(sgeList);
        sendWR.setWr_id((long)wrid);
        sendWRs.add(sendWR);
        sendWR.setSend_flags(IbvSendWR.IBV_SEND_SIGNALED);
        sendWR.setOpcode(IbvSendWR.IbvWrOcode.IBV_WR_SEND.ordinal());
        return this.postSend(sendWRs);
    }

    private SVCPostRecv setupRecvTask(int wrid) throws IOException {
        ArrayList<IbvRecvWR> recvWRs = new ArrayList<IbvRecvWR>(1);
        LinkedList<IbvSge> sgeList = new LinkedList<IbvSge>();
        IbvSge sge = new IbvSge();
        sge.setAddr(MemoryUtils.getAddress((ByteBuffer)this.recvBufs[wrid]));
        sge.setLength(this.rawBufferSize);
        sge.setLkey(this.dataMr.getLkey());
        sgeList.add(sge);
        IbvRecvWR recvWR = new IbvRecvWR();
        recvWR.setWr_id((long)wrid);
        recvWR.setSg_list(sgeList);
        recvWRs.add(recvWR);
        return this.postRecv(recvWRs);
    }
}

