/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.darpc;

import com.ibm.darpc.DaRPCClientEndpoint;
import com.ibm.darpc.DaRPCEndpointGroup;
import com.ibm.darpc.DaRPCMessage;
import com.ibm.darpc.DaRPCProtocol;
import com.ibm.disni.RdmaCqProvider;
import com.ibm.disni.RdmaEndpointFactory;
import com.ibm.disni.verbs.IbvCQ;
import com.ibm.disni.verbs.IbvQP;
import com.ibm.disni.verbs.RdmaCmId;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaRPCClientGroup<R extends DaRPCMessage, T extends DaRPCMessage>
extends DaRPCEndpointGroup<DaRPCClientEndpoint<R, T>, R, T> {
    public static <R extends DaRPCMessage, T extends DaRPCMessage> DaRPCClientGroup<R, T> createClientGroup(DaRPCProtocol<R, T> protocol, int timeout, int maxinline, int recvQueue, int sendQueue) throws Exception {
        DaRPCClientGroup<R, T> group = new DaRPCClientGroup<R, T>(protocol, timeout, maxinline, recvQueue, sendQueue);
        group.init(new RpcClientFactory<R, T>(group));
        return group;
    }

    private DaRPCClientGroup(DaRPCProtocol<R, T> protocol, int timeout, int maxinline, int recvQueue, int sendQueue) throws Exception {
        super(protocol, timeout, maxinline, recvQueue, sendQueue);
    }

    public void allocateResources(DaRPCClientEndpoint<R, T> endpoint) throws Exception {
        endpoint.allocateResources();
    }

    public RdmaCqProvider createCqProvider(DaRPCClientEndpoint<R, T> endpoint) throws IOException {
        return new RdmaCqProvider(endpoint.getIdPriv().getVerbs(), this.recvQueueSize() + this.sendQueueSize());
    }

    public IbvQP createQpProvider(DaRPCClientEndpoint<R, T> endpoint) throws IOException {
        RdmaCqProvider cqProvider = endpoint.getCqProvider();
        IbvCQ cq = cqProvider.getCQ();
        IbvQP qp = this.createQP(endpoint.getIdPriv(), endpoint.getPd(), cq);
        return qp;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RpcClientFactory<R extends DaRPCMessage, T extends DaRPCMessage>
    implements RdmaEndpointFactory<DaRPCClientEndpoint<R, T>> {
        private DaRPCClientGroup<R, T> group;

        public RpcClientFactory(DaRPCClientGroup<R, T> group) {
            this.group = group;
        }

        public DaRPCClientEndpoint<R, T> createEndpoint(RdmaCmId id, boolean serverSide) throws IOException {
            return new DaRPCClientEndpoint(this.group, id, serverSide);
        }
    }
}

