/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.darpc;

import com.ibm.darpc.DaRPCEndpoint;
import com.ibm.darpc.DaRPCEndpointGroup;
import com.ibm.darpc.DaRPCFuture;
import com.ibm.darpc.DaRPCMessage;
import com.ibm.darpc.DaRPCStream;
import com.ibm.disni.verbs.IbvCQ;
import com.ibm.disni.verbs.IbvWC;
import com.ibm.disni.verbs.RdmaCmId;
import com.ibm.disni.verbs.SVCPollCq;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaRPCClientEndpoint<R extends DaRPCMessage, T extends DaRPCMessage>
extends DaRPCEndpoint<R, T> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.ibm.darpc");
    private ConcurrentHashMap<Integer, DaRPCFuture<R, T>> pendingFutures = new ConcurrentHashMap();
    private AtomicInteger ticketCount = new AtomicInteger(0);
    private int streamCount = 1;
    private IbvWC[] wcList;
    private SVCPollCq poll;
    private ReentrantLock lock = new ReentrantLock();

    public DaRPCClientEndpoint(DaRPCEndpointGroup<? extends DaRPCClientEndpoint<R, T>, R, T> group, RdmaCmId idPriv, boolean serverSide) throws IOException {
        super(group, idPriv, serverSide);
    }

    @Override
    public void init() throws IOException {
        super.init();
        IbvCQ cq = this.getCqProvider().getCQ();
        this.wcList = new IbvWC[this.getCqProvider().getCqSize()];
        for (int i = 0; i < this.wcList.length; ++i) {
            this.wcList[i] = new IbvWC();
        }
        this.poll = cq.poll(this.wcList, this.wcList.length);
    }

    public DaRPCStream<R, T> createStream() throws IOException {
        int streamId = this.streamCount++;
        DaRPCStream stream = new DaRPCStream(this, streamId);
        return stream;
    }

    int sendRequest(DaRPCFuture<R, T> future) throws IOException {
        int ticket = this.getAndIncrement();
        future.stamp(ticket);
        this.pendingFutures.put(future.getTicket(), future);
        while (!this.sendMessage((DaRPCMessage)future.getSendMessage(), future.getTicket())) {
            this.pollOnce();
        }
        return ticket;
    }

    @Override
    public void dispatchReceive(ByteBuffer recvBuffer, int ticket, int recvIndex) throws IOException {
        DaRPCFuture<R, T> future = this.pendingFutures.get(ticket);
        if (future == null) {
            logger.info("no pending future (receive) for ticket " + ticket);
            throw new IOException("no pending future (receive) for ticket " + ticket);
        }
        future.getReceiveMessage().update(recvBuffer);
        this.postRecv(recvIndex);
        if (future.touch()) {
            this.pendingFutures.remove(ticket);
            this.freeSend(ticket);
        }
        future.signal(0);
    }

    @Override
    public void dispatchSend(int ticket) throws IOException {
        DaRPCFuture<R, T> future = this.pendingFutures.get(ticket);
        if (future == null) {
            logger.info("no pending future (send) for ticket " + ticket);
            throw new IOException("no pending future (send) for ticket " + ticket);
        }
        if (future.touch()) {
            this.pendingFutures.remove(ticket);
            this.freeSend(ticket);
        }
    }

    private int getAndIncrement() {
        return this.ticketCount.getAndIncrement() & Integer.MAX_VALUE;
    }

    public void pollOnce() throws IOException {
        if (!this.lock.tryLock()) {
            return;
        }
        try {
            this._pollOnce();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pollUntil(AtomicInteger future, long timeout) throws IOException {
        boolean locked = false;
        do {
            locked = this.lock.tryLock();
        } while (future.get() <= 0 && !locked);
        try {
            if (future.get() == 0) {
                this._pollUntil(future, timeout);
            }
        }
        finally {
            if (locked) {
                this.lock.unlock();
            }
        }
    }

    private int _pollOnce() throws IOException {
        int res = ((SVCPollCq)this.poll.execute()).getPolls();
        if (res > 0) {
            for (int i = 0; i < res; ++i) {
                IbvWC wc = this.wcList[i];
                this.dispatchCqEvent(wc);
            }
        }
        return res;
    }

    private int _pollUntil(AtomicInteger future, long timeout) throws IOException {
        long count = 0L;
        long checkTimeOut = 16384L;
        long startTime = System.nanoTime();
        while (future.get() == 0) {
            int res = ((SVCPollCq)this.poll.execute()).getPolls();
            if (res > 0) {
                for (int i = 0; i < res; ++i) {
                    IbvWC wc = this.wcList[i];
                    this.dispatchCqEvent(wc);
                }
            }
            if (count == 16384L) {
                count = 0L;
                if ((double)(System.nanoTime() - startTime) / 1000000.0 > (double)timeout) break;
            }
            ++count;
        }
        return 1;
    }
}

