/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.hdfs.tools;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Random;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;

public class HdfsIOBenchmark {
    private String mode;
    private int size;
    private int loop;
    private Path path;

    public HdfsIOBenchmark(String[] args) {
        this.mode = args[0];
        this.size = Integer.parseInt(args[1]);
        this.loop = Integer.parseInt(args[2]);
        this.path = new Path(args[3]);
    }

    public void run() throws Exception {
        if (this.mode.equals("writeSequentialHeap")) {
            this.writeSequentialHeap();
        } else if (this.mode.equalsIgnoreCase("readSequentialDirect")) {
            this.readSequentialDirect();
        } else if (this.mode.equals("readSequentialHeap")) {
            this.readSequentialHeap();
        } else if (this.mode.equals("readRandomDirect")) {
            this.readRandomDirect();
        } else if (this.mode.equals("readRandomHeap")) {
            this.readRandomHeap();
        } else if (this.mode.equals("getFile")) {
            this.getFile();
        } else if (this.mode.equals("createFile")) {
            this.createFile();
        } else if (this.mode.equals("enumerateDir")) {
            this.enumerateDir();
        } else if (this.mode.equals("keyGet")) {
            this.keyGet();
        } else if (this.mode.equals("browseDir")) {
            this.browseDir();
        } else {
            HdfsIOBenchmark.usage();
            System.exit(0);
        }
    }

    public static void usage() {
        System.out.println("Usage:");
        System.out.println("hdfsbench <readSequentialDirect|readSequentialHeap|readRandomDirect|readRandomHeap|writeSequentialHeap> <size> <iterations> <path>");
    }

    public void writeSequentialHeap() throws Exception {
        double ops;
        System.out.println("writing sequential file in heap mode " + this.path);
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        FSDataOutputStream instream = fs.create(this.path);
        byte[] buf = new byte[this.size];
        double sumbytes = 0.0;
        System.out.println("read size " + this.size);
        System.out.println("operations " + this.loop);
        long start = System.currentTimeMillis();
        for (ops = 0.0; ops < (double)this.loop; ops += 1.0) {
            instream.write(buf, 0, buf.length);
            sumbytes += (double)buf.length;
        }
        instream.flush();
        long end = System.currentTimeMillis();
        double executionTime = (double)(end - start) / 1000.0;
        double throughput = 0.0;
        double latency = 0.0;
        double sumbits = sumbytes * 8.0;
        if (executionTime > 0.0) {
            throughput = sumbits / executionTime / 1024.0 / 1024.0;
            latency = 1000000.0 * executionTime / ops;
        }
        System.out.println("execution time " + executionTime);
        System.out.println("ops " + ops);
        System.out.println("sumbytes " + sumbytes);
        System.out.println("throughput " + throughput);
        System.out.println("latency " + latency);
        System.out.println("closing stream");
        instream.close();
        fs.close();
    }

    public void readSequentialDirect() throws Exception {
        System.out.println("reading sequential file in direct mode " + this.path);
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        FileStatus status = fs.getFileStatus(this.path);
        FSDataInputStream instream = fs.open(this.path);
        ByteBuffer buf = ByteBuffer.allocateDirect(this.size);
        buf.clear();
        double sumbytes = 0.0;
        double ops = 0.0;
        System.out.println("file capacity " + status.getLen());
        System.out.println("read size " + this.size);
        System.out.println("operations " + this.loop);
        long start = System.currentTimeMillis();
        while (ops < (double)this.loop) {
            buf.clear();
            double ret = instream.read(buf);
            if (ret > 0.0) {
                sumbytes += ret;
                ops += 1.0;
                continue;
            }
            ops += 1.0;
            if (instream.getPos() == 0L) break;
            instream.seek(0L);
        }
        long end = System.currentTimeMillis();
        double executionTime = (double)(end - start) / 1000.0;
        double throughput = 0.0;
        double latency = 0.0;
        double sumbits = sumbytes * 8.0;
        if (executionTime > 0.0) {
            throughput = sumbits / executionTime / 1024.0 / 1024.0;
            latency = 1000000.0 * executionTime / ops;
        }
        System.out.println("execution time " + executionTime);
        System.out.println("ops " + ops);
        System.out.println("sumbytes " + sumbytes);
        System.out.println("throughput " + throughput);
        System.out.println("latency " + latency);
        System.out.println("closing stream");
        instream.close();
        fs.close();
    }

    public void readSequentialHeap() throws Exception {
        System.out.println("reading sequential file in heap mode " + this.path);
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        FileStatus status = fs.getFileStatus(this.path);
        FSDataInputStream instream = fs.open(this.path);
        byte[] buf = new byte[this.size];
        double sumbytes = 0.0;
        double ops = 0.0;
        System.out.println("file capacity " + status.getLen());
        System.out.println("read size " + this.size);
        System.out.println("operations " + this.loop);
        long start = System.currentTimeMillis();
        while (ops < (double)this.loop) {
            double ret = this.read(instream, buf);
            if (ret > 0.0) {
                sumbytes += ret;
                ops += 1.0;
                continue;
            }
            ops += 1.0;
            if (instream.getPos() == 0L) break;
            instream.seek(0L);
        }
        long end = System.currentTimeMillis();
        double executionTime = (double)(end - start) / 1000.0;
        double throughput = 0.0;
        double latency = 0.0;
        double sumbits = sumbytes * 8.0;
        if (executionTime > 0.0) {
            throughput = sumbits / executionTime / 1024.0 / 1024.0;
            latency = 1000000.0 * executionTime / ops;
        }
        System.out.println("execution time " + executionTime);
        System.out.println("ops " + ops);
        System.out.println("sumbytes " + sumbytes);
        System.out.println("throughput " + throughput);
        System.out.println("latency " + latency);
        System.out.println("closing stream");
        instream.close();
        fs.close();
    }

    public void readRandomDirect() throws Exception {
        double ops;
        System.out.println("reading random file in direct mode " + this.path);
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        FileStatus status = fs.getFileStatus(this.path);
        FSDataInputStream instream = fs.open(this.path);
        ByteBuffer buf = ByteBuffer.allocateDirect(this.size);
        buf.clear();
        double sumbytes = 0.0;
        long _range = status.getLen() - (long)buf.capacity();
        double range = _range;
        Random random = new Random();
        System.out.println("file capacity " + status.getLen());
        System.out.println("read size " + this.size);
        System.out.println("operations " + this.loop);
        long start = System.currentTimeMillis();
        for (ops = 0.0; ops < (double)this.loop; ops += 1.0) {
            buf.clear();
            double _offset = range * random.nextDouble();
            long offset = (long)_offset;
            instream.seek(offset);
            double ret = instream.read(buf);
            if (!(ret > 0.0)) break;
            sumbytes += ret;
        }
        long end = System.currentTimeMillis();
        double executionTime = (double)(end - start) / 1000.0;
        double throughput = 0.0;
        double latency = 0.0;
        double sumbits = sumbytes * 8.0;
        if (executionTime > 0.0) {
            throughput = sumbits / executionTime / 1024.0 / 1024.0;
            latency = 1000000.0 * executionTime / ops;
        }
        System.out.println("execution time " + executionTime);
        System.out.println("ops " + ops);
        System.out.println("sumbytes " + sumbytes);
        System.out.println("throughput " + throughput);
        System.out.println("latency " + latency);
        System.out.println("closing stream");
        instream.close();
        fs.close();
    }

    public void readRandomHeap() throws Exception {
        double ops;
        System.out.println("reading random file in heap mode " + this.path);
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        FileStatus status = fs.getFileStatus(this.path);
        FSDataInputStream instream = fs.open(this.path);
        byte[] buf = new byte[this.size];
        double sumbytes = 0.0;
        long _range = status.getLen() - (long)buf.length;
        double range = _range;
        Random random = new Random();
        System.out.println("file capacity " + status.getLen());
        System.out.println("read size " + this.size);
        System.out.println("operations " + this.loop);
        long start = System.currentTimeMillis();
        for (ops = 0.0; ops < (double)this.loop; ops += 1.0) {
            double _offset = range * random.nextDouble();
            long offset = (long)_offset;
            instream.seek(offset);
            double ret = this.read(instream, buf);
            if (!(ret > 0.0)) break;
            sumbytes += ret;
        }
        long end = System.currentTimeMillis();
        double executionTime = (double)(end - start) / 1000.0;
        double throughput = 0.0;
        double latency = 0.0;
        double sumbits = sumbytes * 8.0;
        if (executionTime > 0.0) {
            throughput = sumbits / executionTime / 1024.0 / 1024.0;
            latency = 1000000.0 * executionTime / ops;
        }
        System.out.println("execution time " + executionTime);
        System.out.println("ops " + ops);
        System.out.println("sumbytes " + sumbytes);
        System.out.println("throughput " + throughput);
        System.out.println("latency " + latency);
        System.out.println("closing stream");
        instream.close();
        fs.close();
    }

    void getFile() throws Exception, InterruptedException {
        System.out.println("get file, path " + this.path + ", outstanding " + this.size + ", loop " + this.loop);
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path[] paths = new Path[this.loop];
        for (int j = 0; j < this.loop; ++j) {
            paths[j] = new Path(this.path.toString() + "/" + j);
        }
        int repfactor = 4;
        for (int k = 0; k < repfactor; ++k) {
            long start = System.currentTimeMillis();
            for (int i = 0; i < this.size; ++i) {
                for (int j = 0; j < this.loop; ++j) {
                    fs.listStatus(paths[j]);
                }
            }
            long end = System.currentTimeMillis();
            double executionTime = end - start;
            double latency = executionTime * 1000.0 / (double)this.size;
            System.out.println("execution time [ms] " + executionTime);
            System.out.println("latency [us] " + latency);
        }
        fs.close();
    }

    void createFile() throws Exception, InterruptedException {
        System.out.println("create file async hdfs, path " + this.path + ", size " + this.size + ", loop " + this.loop);
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        int repfactor = 4;
        for (int k = 0; k < repfactor; ++k) {
            LinkedBlockingQueue<Path> pathQueue = new LinkedBlockingQueue<Path>();
            fs.mkdirs(this.path);
            for (int i = 0; i < this.loop * this.size; ++i) {
                String name = "" + i;
                Path f = new Path(this.path, name);
                pathQueue.add(f);
            }
            LinkedBlockingQueue streamQueue = new LinkedBlockingQueue();
            long start = System.currentTimeMillis();
            for (int i = 0; i < this.size; ++i) {
                for (int j = 0; j < this.loop; ++j) {
                    Path path = (Path)pathQueue.poll();
                    fs.create(path).close();
                }
            }
            long end = System.currentTimeMillis();
            double executionTime = end - start;
            double latency = executionTime * 1000.0 / (double)this.size;
            System.out.println("execution time [ms] " + executionTime);
            System.out.println("latency [us] " + latency);
            while (!streamQueue.isEmpty()) {
                FSDataOutputStream stream = (FSDataOutputStream)streamQueue.poll();
                stream.close();
            }
            if (k >= repfactor - 1) continue;
            fs.delete(this.path, true);
            Thread.sleep(2000L);
        }
        fs.close();
    }

    void enumerateDir() throws Exception {
        System.out.println("enumarate dir, path " + this.path);
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        int repfactor = 4;
        for (int k = 0; k < repfactor; ++k) {
            long start = System.currentTimeMillis();
            for (int i = 0; i < this.size; ++i) {
                RemoteIterator iter = fs.listFiles(this.path, false);
                while (iter.hasNext()) {
                    iter.next();
                }
            }
            long end = System.currentTimeMillis();
            double executionTime = end - start;
            double latency = executionTime * 1000.0 / (double)this.size;
            System.out.println("execution time [ms] " + executionTime);
            System.out.println("latency [us] " + latency);
        }
        fs.close();
    }

    void keyGet() throws Exception {
        System.out.println("key get, path " + this.path + ", size " + this.size + ", loop " + this.loop);
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path[] paths = new Path[this.loop];
        for (int i = 0; i < this.loop; ++i) {
            String string = "" + i;
            paths[i] = new Path(this.path, string);
            System.out.println("path " + paths[i]);
        }
        byte[] outBuf = new byte[this.size];
        for (Path p : paths) {
            FSDataOutputStream outputStream = fs.create(p);
            outputStream.write(outBuf);
            outputStream.close();
        }
        long l = System.currentTimeMillis();
        ByteBuffer inBuf = ByteBuffer.allocateDirect(this.size);
        for (int i = 0; i < this.loop; ++i) {
            Path p = paths[i];
            FSDataInputStream inputStream = fs.open(p);
            inBuf.clear();
            while (inBuf.remaining() > 0) {
                inputStream.read(inBuf);
            }
            inputStream.close();
        }
        long end = System.currentTimeMillis();
        double executionTime = end - l;
        double latency = executionTime * 1000.0 / (double)this.loop;
        System.out.println("execution time [ms] " + executionTime);
        System.out.println("latency [us] " + latency);
        fs.close();
    }

    private int read(FSDataInputStream stream, byte[] buf) throws IOException {
        int off = 0;
        int len = buf.length;
        int ret = stream.read(buf, off, len);
        while (ret > 0 && len - ret > 0) {
            ret = stream.read(buf, off += ret, len -= ret);
        }
        return off > 0 || ret > 0 ? ret : -1;
    }

    void browseDir() throws Exception {
        System.out.println("reading enumarate dir, path " + this.path);
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        System.out.println("starting benchmark...");
        RemoteIterator iter = fs.listFiles(this.path, false);
        while (iter.hasNext()) {
            LocatedFileStatus status = (LocatedFileStatus)iter.next();
            System.out.println(status.getPath());
        }
        fs.close();
    }

    public static void main(String[] args) {
        if (args.length != 4) {
            HdfsIOBenchmark.usage();
            System.exit(0);
        }
        try {
            HdfsIOBenchmark benchmark = new HdfsIOBenchmark(args);
            benchmark.run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

