/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.hdfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.crail.CrailBlockLocation;
import org.apache.crail.CrailBufferedInputStream;
import org.apache.crail.CrailBufferedOutputStream;
import org.apache.crail.CrailDirectory;
import org.apache.crail.CrailFile;
import org.apache.crail.CrailLocationClass;
import org.apache.crail.CrailNode;
import org.apache.crail.CrailNodeType;
import org.apache.crail.CrailStorageClass;
import org.apache.crail.CrailStore;
import org.apache.crail.conf.CrailConfiguration;
import org.apache.crail.conf.CrailConstants;
import org.apache.crail.hdfs.CrailHDFSInputStream;
import org.apache.crail.hdfs.CrailHDFSOutputStream;
import org.apache.crail.rpc.RpcErrors;
import org.apache.crail.utils.CrailUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;

public class CrailHadoopFileSystem
extends FileSystem {
    private static final Logger LOG = CrailUtils.getLogger();
    private CrailStore dfs;
    private Path workingDir;
    private URI uri;

    public CrailHadoopFileSystem() throws IOException {
        LOG.info("CrailHadoopFileSystem construction");
        this.dfs = null;
    }

    public void initialize(URI uri, Configuration conf) throws IOException {
        super.initialize(uri, conf);
        this.setConf(conf);
        try {
            CrailConfiguration crailConf = CrailConfiguration.createConfigurationFromFile();
            this.dfs = CrailStore.newInstance((CrailConfiguration)crailConf);
            Path _workingDir = new Path("/user/" + CrailConstants.USER);
            this.workingDir = new Path("/user/" + CrailConstants.USER).makeQualified(uri, _workingDir);
            this.uri = URI.create(CrailConstants.NAMENODE_ADDRESS);
            LOG.info("CrailHadoopFileSystem fs initialization done..");
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public String getScheme() {
        return "crail";
    }

    public URI getUri() {
        return this.uri;
    }

    public FSDataInputStream open(Path path, int bufferSize) throws IOException {
        this.statistics.incrementReadOps(1);
        CrailFile fileInfo = null;
        try {
            fileInfo = ((CrailNode)this.dfs.lookup(path.toUri().getRawPath()).get()).asFile();
            CrailBufferedInputStream inputStream = fileInfo.getBufferedInputStream(fileInfo.getCapacity());
            return new CrailHDFSInputStream(inputStream, this.statistics);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public FSDataOutputStream create(Path path, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        this.statistics.incrementWriteOps(1);
        CrailFile fileInfo = null;
        try {
            fileInfo = ((CrailNode)this.dfs.create(path.toUri().getRawPath(), CrailNodeType.DATAFILE, CrailStorageClass.PARENT, CrailLocationClass.PARENT, true).get()).asFile();
        }
        catch (Exception e) {
            if (e.getMessage().contains(RpcErrors.messages[RpcErrors.ERR_PARENT_MISSING])) {
                fileInfo = null;
            }
            throw new IOException(e);
        }
        if (fileInfo == null) {
            Path parent = path.getParent();
            this.mkdirs(parent, FsPermission.getDirDefault());
            try {
                fileInfo = ((CrailNode)this.dfs.create(path.toUri().getRawPath(), CrailNodeType.DATAFILE, CrailStorageClass.PARENT, CrailLocationClass.PARENT, true).get()).asFile();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        CrailBufferedOutputStream outputStream = null;
        if (fileInfo != null) {
            try {
                fileInfo.syncDir();
                outputStream = fileInfo.getBufferedOutputStream(Integer.MAX_VALUE);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        if (outputStream != null) {
            return new CrailHDFSOutputStream(outputStream, this.statistics);
        }
        throw new IOException("Failed to create file, path " + path.toString());
    }

    public FSDataOutputStream append(Path path, int bufferSize, Progressable progress) throws IOException {
        throw new IOException("Append not supported");
    }

    public boolean rename(Path src, Path dst) throws IOException {
        try {
            this.statistics.incrementWriteOps(1);
            CrailNode file = (CrailNode)this.dfs.rename(src.toUri().getRawPath(), dst.toUri().getRawPath()).get();
            if (file != null) {
                file.syncDir();
            }
            return file != null;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public boolean delete(Path path, boolean recursive) throws IOException {
        try {
            this.statistics.incrementWriteOps(1);
            CrailNode file = (CrailNode)this.dfs.delete(path.toUri().getRawPath(), recursive).get();
            if (file != null) {
                file.syncDir();
            }
            return file != null;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public FileStatus[] listStatus(Path path) throws FileNotFoundException, IOException {
        try {
            CrailNode node = (CrailNode)this.dfs.lookup(path.toUri().getRawPath()).get();
            Iterator iter = node.asContainer().listEntries();
            ArrayList<FileStatus> statusList = new ArrayList<FileStatus>();
            while (iter.hasNext()) {
                String filepath = (String)iter.next();
                CrailNode directFile = (CrailNode)this.dfs.lookup(filepath).get();
                if (directFile == null) continue;
                FsPermission permission = FsPermission.getFileDefault();
                if (directFile.getType().isDirectory()) {
                    permission = FsPermission.getDirDefault();
                }
                FileStatus status = new FileStatus(directFile.getCapacity(), directFile.getType().isContainer(), CrailConstants.SHADOW_REPLICATION, CrailConstants.BLOCK_SIZE, directFile.getModificationTime(), directFile.getModificationTime(), permission, CrailConstants.USER, CrailConstants.USER, new Path(filepath).makeQualified(this.getUri(), this.workingDir));
                statusList.add(status);
            }
            FileStatus[] list = new FileStatus[statusList.size()];
            statusList.toArray(list);
            return list;
        }
        catch (Exception e) {
            throw new FileNotFoundException(path.toUri().getRawPath());
        }
    }

    public void setWorkingDirectory(Path new_dir) {
        this.workingDir = new_dir;
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    public boolean mkdirs(Path path, FsPermission permission) throws IOException {
        try {
            this.statistics.incrementWriteOps(1);
            CrailDirectory file = ((CrailNode)this.dfs.create(path.toUri().getRawPath(), CrailNodeType.DIRECTORY, CrailStorageClass.PARENT, CrailLocationClass.DEFAULT, true).get()).asDirectory();
            file.syncDir();
            return true;
        }
        catch (Exception e) {
            if (e.getMessage().contains(RpcErrors.messages[RpcErrors.ERR_PARENT_MISSING])) {
                Path parent = path.getParent();
                this.mkdirs(parent);
                return this.mkdirs(path);
            }
            if (e.getMessage().contains(RpcErrors.messages[RpcErrors.ERR_FILE_EXISTS])) {
                return true;
            }
            throw new IOException(e);
        }
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        this.statistics.incrementReadOps(1);
        CrailNode directFile = null;
        try {
            directFile = (CrailNode)this.dfs.lookup(path.toUri().getRawPath()).get();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        if (directFile == null) {
            throw new FileNotFoundException("File does not exist: " + path);
        }
        FsPermission permission = FsPermission.getFileDefault();
        if (directFile.getType().isDirectory()) {
            permission = FsPermission.getDirDefault();
        }
        FileStatus status = new FileStatus(directFile.getCapacity(), directFile.getType().isContainer(), CrailConstants.SHADOW_REPLICATION, CrailConstants.BLOCK_SIZE, directFile.getModificationTime(), directFile.getModificationTime(), permission, CrailConstants.USER, CrailConstants.USER, path.makeQualified(this.getUri(), this.workingDir));
        return status;
    }

    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        return this.getFileBlockLocations(file.getPath(), start, len);
    }

    public BlockLocation[] getFileBlockLocations(Path path, long start, long len) throws IOException {
        try {
            this.statistics.incrementReadOps(1);
            CrailBlockLocation[] _locations = ((CrailNode)this.dfs.lookup(path.toUri().getRawPath()).get()).asFile().getBlockLocations(start, len);
            BlockLocation[] locations = new BlockLocation[_locations.length];
            for (int i = 0; i < locations.length; ++i) {
                locations[i] = new BlockLocation();
                locations[i].setOffset(_locations[i].getOffset());
                locations[i].setLength(_locations[i].getLength());
                locations[i].setNames(_locations[i].getNames());
                locations[i].setHosts(_locations[i].getHosts());
                locations[i].setTopologyPaths(_locations[i].getTopology());
            }
            return locations;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public FsStatus getStatus(Path p) throws IOException {
        this.statistics.incrementReadOps(1);
        return new FsStatus(Long.MAX_VALUE, 0L, Long.MAX_VALUE);
    }

    public void close() throws IOException {
        try {
            LOG.info("Closing CrailHadoopFileSystem");
            super.processDeleteOnExit();
            this.dfs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e);
        }
    }
}

