/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.hdfs;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.crail.CrailBufferedInputStream;
import org.apache.crail.utils.CrailUtils;
import org.apache.hadoop.fs.ByteBufferReadable;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;
import org.slf4j.Logger;

public class CrailHDFSInputStream
extends FSDataInputStream {
    private static final Logger LOG = CrailUtils.getLogger();
    private CrailBufferedInputStream inputStream;
    private FileSystem.Statistics stats;

    public CrailHDFSInputStream(CrailBufferedInputStream stream, FileSystem.Statistics stats) {
        super((InputStream)new CrailSeekable(stream, stats));
        LOG.info("new HDFS stream");
        this.inputStream = stream;
    }

    public long getPos() throws IOException {
        return this.inputStream.position();
    }

    public int read(ByteBuffer buf) throws IOException {
        int res = this.inputStream.read(buf);
        this.updateStats(res);
        return res;
    }

    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        int res = this.inputStream.read(position, buffer, offset, length);
        this.updateStats(res);
        return res;
    }

    public void readFully(long position, byte[] buffer) throws IOException {
        this.readFully(position, buffer, 0, buffer.length);
    }

    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        int nbytes;
        for (int nread = 0; nread < length; nread += nbytes) {
            nbytes = this.read(position + (long)nread, buffer, offset + nread, length - nread);
            if (nbytes >= 0) continue;
            throw new EOFException("End of file reached before reading fully.");
        }
    }

    public boolean seekToNewSource(long targetPos) throws IOException {
        return false;
    }

    public int read() throws IOException {
        int res = this.inputStream.read();
        this.updateStats(4L);
        return res;
    }

    public int available() throws IOException {
        return this.inputStream.available();
    }

    private void updateStats(long len) {
        if (this.stats != null && len > 0L) {
            this.stats.incrementBytesRead(len);
        }
    }

    public static class CrailSeekable
    extends InputStream
    implements Seekable,
    PositionedReadable,
    ByteBufferReadable {
        private CrailBufferedInputStream inputStream;
        private FileSystem.Statistics stats;

        public CrailSeekable(CrailBufferedInputStream inputStream, FileSystem.Statistics stats) {
            this.inputStream = inputStream;
            this.stats = stats;
        }

        @Override
        public int read() throws IOException {
            int value = this.inputStream.read();
            this.updateStats(4L);
            return value;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int res = this.inputStream.read(b);
            this.updateStats(4L);
            return res;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int res = this.inputStream.read(b, off, len);
            this.updateStats(4L);
            return res;
        }

        @Override
        public long skip(long n) throws IOException {
            return this.inputStream.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.inputStream.available();
        }

        @Override
        public void close() throws IOException {
            this.inputStream.close();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.inputStream.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.inputStream.reset();
        }

        @Override
        public boolean markSupported() {
            return this.inputStream.markSupported();
        }

        public int read(ByteBuffer dataBuf) throws IOException {
            int res = this.inputStream.read(dataBuf);
            this.updateStats(4L);
            return res;
        }

        public int read(long position, byte[] buffer, int offset, int length) throws IOException {
            int res = this.inputStream.read(position, buffer, offset, length);
            this.updateStats(4L);
            return res;
        }

        public void readFully(long position, byte[] buf) throws IOException {
            this.readFully(position, buf, 0, buf.length);
        }

        public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
            int nbytes;
            for (int nread = 0; nread < length; nread += nbytes) {
                nbytes = this.read(position + (long)nread, buffer, offset + nread, length - nread);
                if (nbytes >= 0) continue;
                throw new EOFException("End of file reached before reading fully.");
            }
        }

        public long getPos() throws IOException {
            return this.inputStream.position();
        }

        public void seek(long n) throws IOException {
            this.inputStream.seek(n);
        }

        public boolean seekToNewSource(long targetPos) throws IOException {
            return false;
        }

        private void updateStats(long len) {
            if (this.stats != null && len > 0L) {
                this.stats.incrementBytesRead(len);
            }
        }
    }
}

