/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.hdfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;
import org.apache.crail.hdfs.CrailHadoopFileSystem;
import org.apache.crail.utils.CrailUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;

public class CrailHDFS
extends AbstractFileSystem {
    private static final Logger LOG = CrailUtils.getLogger();
    private CrailHadoopFileSystem dfs = new CrailHadoopFileSystem();

    public CrailHDFS(URI uri, Configuration conf) throws IOException, URISyntaxException {
        super(uri, "crail", true, 9000);
        this.dfs.initialize(uri, conf);
    }

    public int getUriDefaultPort() {
        return 9000;
    }

    public FsServerDefaults getServerDefaults() throws IOException {
        return this.dfs.getServerDefaults(this.dfs.getWorkingDirectory());
    }

    public FSDataOutputStream createInternal(Path path, EnumSet<CreateFlag> flag, FsPermission absolutePermission, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt, boolean createParent) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, UnsupportedFileSystemException, UnresolvedLinkException, IOException {
        return this.dfs.create(path, absolutePermission, false, bufferSize, replication, blockSize, progress);
    }

    public void mkdir(Path path, FsPermission permission, boolean createParent) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, UnresolvedLinkException, IOException {
        this.dfs.mkdirs(path, permission);
    }

    public boolean delete(Path path, boolean recursive) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        return this.dfs.delete(path, recursive);
    }

    public FSDataInputStream open(Path path, int bufferSize) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        return this.dfs.open(path, bufferSize);
    }

    public boolean setReplication(Path f, short replication) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        return this.dfs.setReplication(f, replication);
    }

    public void renameInternal(Path src, Path dst) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, UnresolvedLinkException, IOException {
        this.dfs.rename(src, dst);
    }

    public void setPermission(Path f, FsPermission permission) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        this.dfs.setPermission(f, permission);
    }

    public void setOwner(Path f, String username, String groupname) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
    }

    public void setTimes(Path f, long mtime, long atime) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
    }

    public FileChecksum getFileChecksum(Path f) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        return null;
    }

    public FileStatus getFileStatus(Path path) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        return this.dfs.getFileStatus(path);
    }

    public BlockLocation[] getFileBlockLocations(Path path, long start, long len) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        return this.dfs.getFileBlockLocations(path, start, len);
    }

    public FsStatus getFsStatus() throws AccessControlException, FileNotFoundException, IOException {
        return this.dfs.getStatus();
    }

    public FileStatus[] listStatus(Path path) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        return this.dfs.listStatus(path);
    }

    public void setVerifyChecksum(boolean verifyChecksum) throws AccessControlException, IOException {
        this.dfs.setVerifyChecksum(verifyChecksum);
    }
}

