/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.storage.nvmf.client;

import java.io.IOException;
import java.util.HashSet;
import org.apache.crail.CrailBuffer;
import org.apache.crail.CrailBufferCache;
import org.apache.crail.conf.CrailConfiguration;
import org.apache.crail.conf.CrailConstants;
import org.apache.crail.memory.MappedBufferCache;
import org.apache.crail.storage.nvmf.client.NvmfStagingBufferCache;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class NvmfStagingBufferCacheTest {
    private static CrailBufferCache bufferCache;

    @BeforeClass
    public static void init() throws IOException {
        CrailConstants.updateConstants((CrailConfiguration)CrailConfiguration.createConfigurationFromFile());
    }

    static CrailBufferCache getBufferCache() throws IOException {
        if (bufferCache == null) {
            bufferCache = new MappedBufferCache();
        }
        return bufferCache;
    }

    @Test(expected=IllegalArgumentException.class)
    public void createBufferCache() throws IOException {
        new NvmfStagingBufferCache(NvmfStagingBufferCacheTest.getBufferCache(), -1, 512);
        new NvmfStagingBufferCache(NvmfStagingBufferCacheTest.getBufferCache(), 0, 512);
        new NvmfStagingBufferCache(NvmfStagingBufferCacheTest.getBufferCache(), 1024, -1);
        new NvmfStagingBufferCache(NvmfStagingBufferCacheTest.getBufferCache(), 1024, 0);
    }

    @Test(expected=OutOfMemoryError.class)
    public void outOfMemory() throws Exception {
        NvmfStagingBufferCache bufferCache = new NvmfStagingBufferCache(NvmfStagingBufferCacheTest.getBufferCache(), 1, 512);
        NvmfStagingBufferCache.BufferCacheEntry bufferCacheEntry = bufferCache.get(0L);
        NvmfStagingBufferCache.BufferCacheEntry bufferCacheEntry2 = bufferCache.get(1L);
    }

    @Test
    public void bufferExists() throws Exception {
        NvmfStagingBufferCache bufferCache = new NvmfStagingBufferCache(NvmfStagingBufferCacheTest.getBufferCache(), 1, 512);
        NvmfStagingBufferCache.BufferCacheEntry bufferCacheEntry = bufferCache.get(0L);
        NvmfStagingBufferCache.BufferCacheEntry existingBufferCacheEntry = bufferCache.getExisting(0L);
        Assert.assertEquals((Object)bufferCacheEntry, (Object)existingBufferCacheEntry);
    }

    @Test
    public void recycleBuffers() throws Exception {
        int i;
        NvmfStagingBufferCache.BufferCacheEntry[] bufferCacheEntry = new NvmfStagingBufferCache.BufferCacheEntry[5];
        HashSet<CrailBuffer> buffers = new HashSet<CrailBuffer>();
        NvmfStagingBufferCache bufferCache = new NvmfStagingBufferCache(NvmfStagingBufferCacheTest.getBufferCache(), bufferCacheEntry.length, 512);
        for (i = 0; i < bufferCacheEntry.length; ++i) {
            bufferCacheEntry[i] = bufferCache.get((long)i);
            buffers.add(bufferCacheEntry[i].getBuffer());
            bufferCacheEntry[i].put();
        }
        for (i = 0; i < bufferCacheEntry.length; ++i) {
            bufferCacheEntry[i] = bufferCache.get((long)(i + bufferCacheEntry.length));
            Assert.assertTrue((boolean)buffers.remove(bufferCacheEntry[i].getBuffer()));
        }
    }
}

