/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jnvmf;

import com.ibm.jnvmf.CommandType;
import com.ibm.jnvmf.LegacySupport;
import com.ibm.jnvmf.NativeBuffer;
import com.ibm.jnvmf.NativeData;

public abstract class SubmissionQueueEntry
extends NativeData<NativeBuffer> {
    public static final int SIZE = 64;
    private static final int OPCODE_OFFSET = 0;
    private static final int COMMAND_IDENTIFIER_OFFSET = 2;
    private static final int SGL_DESCRIPTOR1_OFFSET = 24;

    SubmissionQueueEntry(NativeBuffer buffer) {
        super(buffer, 64);
    }

    final void setOpcode(CommandType opcode) {
        this.getBuffer().put(0, opcode.toByte());
    }

    final NativeBuffer getSglDescriptor1Buffer() {
        this.getBuffer().position(24);
        this.getBuffer().limit(this.getBuffer().position() + 16);
        NativeBuffer sglDescriptorBuffer = this.getBuffer().slice();
        this.getBuffer().clear();
        return sglDescriptorBuffer;
    }

    final void setCommandIdentifier(short commandIdentifier) {
        this.getBuffer().putShort(2, commandIdentifier);
    }

    @Override
    void initialize() {
        if (LegacySupport.ENABLED) {
            LegacySupport.initializeSubmissionQueueEntry(this.getBuffer());
        }
    }
}

