/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jnvmf;

import com.ibm.disni.verbs.IbvMr;
import com.ibm.disni.verbs.IbvSendWR;
import com.ibm.disni.verbs.IbvWC;
import com.ibm.disni.verbs.SVCPostSend;
import com.ibm.disni.verbs.SVCRegMr;
import com.ibm.jnvmf.Command;
import com.ibm.jnvmf.CommandCapsule;
import com.ibm.jnvmf.CommandFuture;
import com.ibm.jnvmf.CompletionQueueEntry;
import com.ibm.jnvmf.Controller;
import com.ibm.jnvmf.FabricsConnectCommand;
import com.ibm.jnvmf.FabricsConnectCommandCapsule;
import com.ibm.jnvmf.FabricsConnectCommandData;
import com.ibm.jnvmf.FabricsConnectCommandSqe;
import com.ibm.jnvmf.FabricsConnectResponseCapsule;
import com.ibm.jnvmf.FabricsConnectResponseCqe;
import com.ibm.jnvmf.Freeable;
import com.ibm.jnvmf.GenericStatusCode;
import com.ibm.jnvmf.IdentifyControllerData;
import com.ibm.jnvmf.KeyedNativeBuffer;
import com.ibm.jnvmf.KeyedNativeBufferPool;
import com.ibm.jnvmf.NativeByteBuffer;
import com.ibm.jnvmf.NvmfRdmaEndpoint;
import com.ibm.jnvmf.QueueId;
import com.ibm.jnvmf.RdmaByteBuffer;
import com.ibm.jnvmf.RdmaCmRequestPrivateData;
import com.ibm.jnvmf.RdmaException;
import com.ibm.jnvmf.RdmaRecv;
import com.ibm.jnvmf.Response;
import com.ibm.jnvmf.ResponseFuture;
import com.ibm.jnvmf.UnsuccessfulComandException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public abstract class QueuePair
implements Freeable {
    private static final int POLL_CQ_BATCHSIZE = 32;
    private boolean valid;
    private final Controller controller;
    private final NvmfRdmaEndpoint endpoint;
    private final QueueId queueId;
    private final short submissionQueueSize;
    private final int additionalSgls;
    private RdmaRecv[] rdmaReceives;
    private final Response[] responseMap;
    private KeyedNativeBufferPool commandBufferPool;
    private final int maxCommandCapsuleSize;
    private final int inCapsuleDataSize;
    private final Command[] commandMap;
    private final Queue<Short> freeCommandId;
    private ThreadLocal<NvmfRdmaEndpoint.PollCq> pollCq;

    FabricsConnectResponseCqe connect(long timeout, TimeUnit timeoutUnit) throws IOException {
        FabricsConnectResponseCapsule responseCapsule;
        NativeByteBuffer buffer = new NativeByteBuffer(ByteBuffer.allocateDirect(32));
        RdmaCmRequestPrivateData privateData = new RdmaCmRequestPrivateData(buffer);
        privateData.setQueueId(this.queueId);
        privateData.setRdmaQpReceiveQueueSize(this.submissionQueueSize);
        privateData.setRdmaQpSendQueueSize((short)(this.submissionQueueSize - 1));
        this.endpoint.getConnParam().setPrivate_data(buffer.getAddress());
        this.endpoint.getConnParam().setPrivate_data_len((byte)32);
        InetSocketAddress socketAddress = this.controller.getTransportId().getAddress();
        try {
            this.endpoint.connect(socketAddress, (int)TimeUnit.MILLISECONDS.convert(timeout, timeoutUnit));
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
        this.commandBufferPool = this.endpoint.getBufferPool(this.maxCommandCapsuleSize);
        this.rdmaReceives = this.endpoint.getRdmaReceives();
        this.pollCq = ThreadLocal.withInitial(() -> {
            try {
                NvmfRdmaEndpoint nvmfRdmaEndpoint = this.endpoint;
                ((Object)((Object)nvmfRdmaEndpoint)).getClass();
                return new NvmfRdmaEndpoint.PollCq(nvmfRdmaEndpoint, 32);
            }
            catch (IOException exception) {
                throw new IllegalStateException(exception);
            }
        });
        ByteBuffer dataBuffer = ByteBuffer.allocateDirect(1024);
        KeyedNativeBuffer registeredDataBuffer = this.registerMemory(dataBuffer);
        FabricsConnectCommandData connectCommandData = new FabricsConnectCommandData(registeredDataBuffer);
        connectCommandData.setControllerId(this.controller.getControllerId());
        connectCommandData.setHostNvmeQualifiedName(this.controller.getHostNvmeQualifiedName());
        connectCommandData.setSubsystemNvmeQualifiedName(this.controller.getTransportId().getSubsystemNqn());
        FabricsConnectCommand command = new FabricsConnectCommand(this);
        CommandFuture commandFuture = command.newCommandFuture();
        FabricsConnectCommandCapsule connectCommand = (FabricsConnectCommandCapsule)command.getCommandCapsule();
        connectCommand.setSglDescriptor(connectCommandData);
        FabricsConnectCommandSqe connectCommandSqe = (FabricsConnectCommandSqe)connectCommand.getSubmissionQueueEntry();
        connectCommandSqe.setQueueId(this.queueId);
        connectCommandSqe.setSubmissionQueueSize(this.submissionQueueSize);
        ResponseFuture responseFuture = command.newResponseFuture();
        command.execute(responseFuture);
        try {
            commandFuture.get();
            responseCapsule = (FabricsConnectResponseCapsule)responseFuture.get();
        }
        catch (InterruptedException exception) {
            throw new IOException(exception);
        }
        catch (ExecutionException exception) {
            throw new IOException(exception);
        }
        connectCommand.free();
        registeredDataBuffer.free();
        FabricsConnectResponseCqe cqe = (FabricsConnectResponseCqe)responseCapsule.getCompletionQueueEntry();
        if (!cqe.getStatusCode().equals(GenericStatusCode.getInstance().SUCCESS)) {
            throw new UnsuccessfulComandException(cqe);
        }
        return cqe;
    }

    QueuePair(Controller controller, QueueId queueId, short submissionQueueSize) throws IOException {
        this(controller, queueId, submissionQueueSize, 0, 0, 0);
    }

    QueuePair(Controller controller, QueueId queueId, short submissionQueueSize, int additionalSgls, int inCapsuleDataSize, int maxInlineSize) throws IOException {
        int maxCommandCapsuleSize;
        IdentifyControllerData identifyControllerData;
        this.controller = controller;
        this.queueId = queueId;
        this.endpoint = (NvmfRdmaEndpoint)controller.getEndpointGroup().createEndpoint();
        this.endpoint.setCqSize(2 * submissionQueueSize);
        this.endpoint.setRqSize(submissionQueueSize);
        this.endpoint.setSqSize(submissionQueueSize);
        this.endpoint.setInlineDataSize(maxInlineSize);
        this.submissionQueueSize = submissionQueueSize;
        this.responseMap = new Response[submissionQueueSize];
        if (additionalSgls < 0) {
            throw new IllegalArgumentException("Additional SGLs negative");
        }
        if (inCapsuleDataSize < 0) {
            throw new IllegalArgumentException("inCapsuleDataSize negative");
        }
        this.inCapsuleDataSize = inCapsuleDataSize;
        if (maxInlineSize < 0) {
            throw new IllegalArgumentException("maxInlineSize negative");
        }
        if (additionalSgls > 0 && additionalSgls + 1 > (identifyControllerData = controller.getIdentifyControllerData()).getMaximumSglDataBlockDescriptors() && identifyControllerData.getMaximumSglDataBlockDescriptors() != 0) {
            throw new IllegalArgumentException("Controller only supports " + (identifyControllerData.getMaximumSglDataBlockDescriptors() - 1) + " additional SGLs not " + additionalSgls);
        }
        this.additionalSgls = additionalSgls;
        if (inCapsuleDataSize > 0) {
            IdentifyControllerData identifyControllerData2 = controller.getIdentifyControllerData();
            maxCommandCapsuleSize = CommandCapsule.computeCommandCapsuleSize(additionalSgls, identifyControllerData2.getInCapsuleDataOffset(), inCapsuleDataSize);
            if ((long)maxCommandCapsuleSize > identifyControllerData2.getIoQueueCommandCapsuleSupportedSize()) {
                throw new IllegalArgumentException("Command capsule size " + maxCommandCapsuleSize + " to large, max supported size is " + identifyControllerData2.getIoQueueCommandCapsuleSupportedSize());
            }
        } else {
            maxCommandCapsuleSize = CommandCapsule.computeCommandCapsuleSize(additionalSgls, 0, 0);
        }
        this.maxCommandCapsuleSize = maxCommandCapsuleSize;
        this.commandMap = new Command[submissionQueueSize];
        this.freeCommandId = new ArrayBlockingQueue<Short>(submissionQueueSize);
        for (int i = 0; i < submissionQueueSize; ++i) {
            this.freeCommandId.add((short)i);
        }
        this.connect(10L, TimeUnit.SECONDS);
        this.valid = true;
    }

    public KeyedNativeBuffer registerMemory(ByteBuffer buffer) throws IOException {
        IbvMr mr = ((SVCRegMr)((SVCRegMr)this.endpoint.registerMemory(buffer).execute()).free()).getMr();
        return new RdmaByteBuffer(buffer, mr);
    }

    int getInlineDataSize() {
        return this.endpoint.getInlineDataSize();
    }

    SVCPostSend newPostSend(List<IbvSendWR> sendWrList) throws IOException {
        return this.endpoint.postSend(sendWrList);
    }

    KeyedNativeBuffer allocateCommandCapsule() throws IOException {
        return this.commandBufferPool.allocate();
    }

    private short nextCommandIdentifier() throws IOException {
        Short commandId;
        boolean commandCompleted;
        do {
            if ((commandId = this.freeCommandId.poll()) == null) {
                throw new IOException("submission queue full");
            }
            boolean bl = commandCompleted = this.commandMap[commandId] == null;
            if (commandCompleted) continue;
            boolean empty = this.freeCommandId.isEmpty();
            this.freeCommandId.add(commandId);
            if (!empty) continue;
            throw new IOException("submission queue full");
        } while (!commandCompleted);
        assert (this.responseMap[commandId] == null);
        return commandId;
    }

    final void post(Command command, SVCPostSend postSend, Response response) throws IOException {
        command.getCallback().onStart();
        response.getCallback().onStart();
        short commandId = this.nextCommandIdentifier();
        command.setCommandId(commandId);
        this.responseMap[commandId] = response;
        this.commandMap[commandId] = command;
        postSend.getWrMod(0).setWr_id((long)commandId);
        postSend.execute();
    }

    private final void handleSendWc(IbvWC wc) throws IOException {
        int wrId = (int)wc.getWr_id();
        Command command = this.commandMap[wrId];
        if (command == null) {
            throw new IOException("No command with CID " + wrId);
        }
        this.commandMap[wrId] = null;
        if (wc.getStatus() != IbvWC.IbvWcStatus.IBV_WC_SUCCESS.ordinal()) {
            command.getCallback().onFailure(RdmaException.fromInteger(wc.getOpcode(), wc.getStatus()));
        } else {
            command.getCallback().onComplete();
        }
    }

    private final void handleReceiveWc(IbvWC wc) throws IOException {
        if (wc.getStatus() != IbvWC.IbvWcStatus.IBV_WC_SUCCESS.ordinal()) {
            for (Response response : this.responseMap) {
                if (response == null) continue;
                response.getCallback().onFailure(RdmaException.fromInteger(wc.getOpcode(), wc.getStatus()));
            }
        } else {
            RdmaRecv receive = this.rdmaReceives[(int)wc.getWr_id()];
            KeyedNativeBuffer buffer = receive.getBuffer();
            short commandId = CompletionQueueEntry.getCommandIdentifier(buffer);
            Response response = this.responseMap[commandId];
            if (response == null) {
                throw new IOException("No response with CID " + commandId);
            }
            this.responseMap[commandId] = null;
            response.update(buffer);
            receive.execute();
            this.freeCommandId.add(commandId);
            response.getCallback().onComplete();
        }
    }

    public int poll() throws IOException {
        NvmfRdmaEndpoint.PollCq pollCq = this.pollCq.get();
        int polls = pollCq.execute().getPolls();
        IbvWC[] wcs = pollCq.getWorkCompletions();
        for (int i = 0; i < polls; ++i) {
            IbvWC wc = wcs[i];
            int opcode = wc.getOpcode();
            if (opcode == IbvWC.IbvWcOpcode.IBV_WC_SEND.getOpcode()) {
                this.handleSendWc(wc);
                continue;
            }
            if (opcode != IbvWC.IbvWcOpcode.IBV_WC_RECV.getOpcode()) continue;
            this.handleReceiveWc(wc);
        }
        return polls;
    }

    public Controller getController() {
        return this.controller;
    }

    public int getMaximumAdditionalSgls() {
        return this.additionalSgls;
    }

    @Override
    public void free() throws IOException {
        if (this.isValid()) {
            this.valid = false;
            for (RdmaRecv receive : this.rdmaReceives) {
                receive.free();
            }
            Arrays.fill(this.commandMap, null);
            Arrays.fill(this.responseMap, null);
            try {
                this.endpoint.close();
            }
            catch (InterruptedException exception) {
                throw new IOException(exception);
            }
        }
    }

    @Override
    public final boolean isValid() {
        return this.valid;
    }

    public int getInCapsuleDataSize() {
        return this.inCapsuleDataSize;
    }

    public short getSubmissionQueueSize() {
        return this.submissionQueueSize;
    }
}

