/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jnvmf;

import com.ibm.disni.verbs.IbvMr;
import com.ibm.disni.verbs.IbvPd;
import com.ibm.disni.verbs.SVCDeregMr;
import com.ibm.disni.verbs.SVCRegMr;
import com.ibm.jnvmf.Freeable;
import com.ibm.jnvmf.KeyedNativeBuffer;
import com.ibm.jnvmf.KeyedNativeBufferPool;
import com.ibm.jnvmf.MemoryAllocator;
import com.ibm.jnvmf.NativeBuffer;
import com.ibm.jnvmf.NativeByteBuffer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;

class PdMemoryPool
implements KeyedNativeBufferPool,
Freeable {
    private final IbvPd protectionDomain;
    private final MemoryAllocator allocator;
    private final ByteOrder endianness;
    private final int elementSize;
    private final int numElementsRegion;
    private final MemoryRegion[] regions;
    private int numFreeRegions;
    private final Queue<KeyedNativeBuffer> freeElements;

    PdMemoryPool(IbvPd protectionDomain, MemoryAllocator allocator, int elementSize, int numElementsRegion, int numRegions, ByteOrder endianness) {
        if (protectionDomain == null) {
            throw new IllegalArgumentException("Protection domain null");
        }
        this.protectionDomain = protectionDomain;
        if (allocator == null) {
            throw new IllegalArgumentException("Allocator null");
        }
        this.allocator = allocator;
        this.endianness = endianness;
        if (elementSize < 1) {
            throw new IllegalArgumentException("Negative or zero element size");
        }
        this.elementSize = elementSize;
        if (numElementsRegion < 1) {
            throw new IllegalArgumentException("Negative or zero number of freeElements per region");
        }
        this.numElementsRegion = numElementsRegion;
        if (numRegions < 1) {
            throw new IllegalArgumentException("Negative or zero number of regions");
        }
        this.regions = new MemoryRegion[numRegions];
        this.numFreeRegions = numRegions;
        this.freeElements = new ArrayBlockingQueue<KeyedNativeBuffer>(numElementsRegion * numRegions);
    }

    synchronized void allocateRegion() throws IOException {
        MemoryRegion region;
        if (!this.freeElements.isEmpty()) {
            return;
        }
        if (this.numFreeRegions > 0) {
            NativeBuffer regionBuffer = this.allocator.allocate(this.elementSize * this.numElementsRegion);
            if (this.regions[this.numFreeRegions - 1] != null) {
                regionBuffer.free();
                throw new RuntimeException("There is already a region allocated in this spot!?");
            }
            region = new MemoryRegion(regionBuffer);
            for (int i = 0; i < this.numElementsRegion; ++i) {
                regionBuffer.limit((i + 1) * this.elementSize);
                regionBuffer.position(i * this.elementSize);
                ByteBuffer buffer = regionBuffer.sliceToByteBuffer();
                buffer.order(this.endianness);
                this.freeElements.add(new Element(buffer, region));
            }
        } else {
            throw new OutOfMemoryError("Cannot allocate new region - limit reached");
        }
        this.regions[--this.numFreeRegions] = region;
    }

    @Override
    public KeyedNativeBuffer allocate() throws IOException {
        KeyedNativeBuffer element;
        do {
            if (!this.freeElements.isEmpty()) continue;
            this.allocateRegion();
        } while ((element = this.freeElements.poll()) == null);
        return element;
    }

    private void free(Element element) {
        Element newElement = new Element(element);
        newElement.order(this.endianness);
        this.freeElements.add(newElement);
    }

    @Override
    public void free() throws IOException {
        for (int i = this.regions.length - 1; i >= this.numFreeRegions && this.regions[i] != null; --i) {
            this.regions[i].free();
            this.regions[i] = null;
        }
        this.numFreeRegions = this.regions.length;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public IbvPd getProtectionDomain() {
        return this.protectionDomain;
    }

    private static class ChildElement
    extends NativeByteBuffer
    implements KeyedNativeBuffer {
        private final Element parent;

        ChildElement(Element parent, ByteBuffer buffer) {
            super(buffer);
            this.parent = parent;
        }

        @Override
        public int getRemoteKey() {
            return this.parent.getRemoteKey();
        }

        @Override
        public int getLocalKey() {
            return this.parent.getLocalKey();
        }

        @Override
        public void free() {
            this.parent.free();
        }

        @Override
        public boolean isValid() {
            return this.parent.isValid();
        }
    }

    private static class Element
    extends NativeByteBuffer
    implements KeyedNativeBuffer {
        private final MemoryRegion region;
        private boolean valid;

        private Element(ByteBuffer buffer, MemoryRegion region) {
            super(buffer);
            this.region = region;
            this.valid = true;
        }

        private Element(Element element) {
            this(element.toByteBuffer(), element.region);
            this.clear();
        }

        @Override
        public int getRemoteKey() {
            return this.region.mr.getRkey();
        }

        @Override
        public int getLocalKey() {
            return this.region.mr.getLkey();
        }

        @Override
        public void free() {
            if (!this.isValid()) {
                throw new IllegalStateException("double free buffer");
            }
            this.valid = false;
            this.region.getOuter().free(this);
        }

        @Override
        public boolean isValid() {
            return this.valid;
        }

        @Override
        protected KeyedNativeBuffer construct(ByteBuffer buffer) {
            return new ChildElement(this, buffer);
        }
    }

    private class MemoryRegion {
        private final NativeBuffer buffer;
        private final IbvMr mr;

        private MemoryRegion(NativeBuffer buffer) throws IOException {
            this.buffer = buffer;
            int access = IbvMr.IBV_ACCESS_LOCAL_WRITE | IbvMr.IBV_ACCESS_REMOTE_READ | IbvMr.IBV_ACCESS_REMOTE_WRITE;
            this.mr = ((SVCRegMr)((SVCRegMr)PdMemoryPool.this.protectionDomain.regMr(buffer.toByteBuffer(), access).execute()).free()).getMr();
        }

        private void free() throws IOException {
            ((SVCDeregMr)this.mr.deregMr().execute()).free();
            this.buffer.free();
        }

        private PdMemoryPool getOuter() {
            return PdMemoryPool.this;
        }
    }
}

