/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jnvmf;

import com.ibm.jnvmf.Operation;
import com.ibm.jnvmf.OperationCallback;
import com.ibm.jnvmf.QueuePair;
import com.ibm.jnvmf.RdmaException;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class OperationFuture<O extends Operation, T>
implements OperationCallback,
Future<T> {
    private final QueuePair queuePair;
    private RdmaException rdmaException;
    private final O operation;
    private volatile boolean done = false;

    OperationFuture(QueuePair queuePair, O operation) {
        this.queuePair = queuePair;
        this.operation = operation;
        ((Operation)operation).setCallback(this);
    }

    private final void checkCompleted() {
        if (this.isDone()) {
            throw new IllegalStateException("Operation already completed");
        }
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onComplete() {
        this.checkCompleted();
        this.done = true;
    }

    @Override
    public void onFailure(RdmaException exception) {
        this.checkCompleted();
        this.rdmaException = exception;
        this.done = true;
    }

    abstract T getT();

    O getOperation() {
        return this.operation;
    }

    @Override
    public boolean cancel(boolean cancel) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    private final void checkStatus() throws ExecutionException {
        if (this.rdmaException != null) {
            throw new ExecutionException(this.rdmaException);
        }
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        while (!this.done) {
            try {
                this.queuePair.poll();
            }
            catch (IOException exception) {
                throw new ExecutionException(exception);
            }
        }
        this.checkStatus();
        return this.getT();
    }

    @Override
    public T get(long timeout, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.done) {
            boolean waitTimeOut;
            long start = System.nanoTime();
            long end = start + TimeUnit.NANOSECONDS.convert(timeout, timeUnit);
            do {
                try {
                    this.queuePair.poll();
                }
                catch (IOException exception) {
                    throw new ExecutionException(exception);
                }
                boolean bl = waitTimeOut = System.nanoTime() > end;
            } while (!this.done && !waitTimeOut);
            if (!this.done && waitTimeOut) {
                throw new TimeoutException("get wait time out!");
            }
        }
        this.checkStatus();
        return this.getT();
    }
}

