/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jnvmf;

import com.ibm.disni.RdmaCqProvider;
import com.ibm.disni.RdmaEndpointGroup;
import com.ibm.disni.verbs.IbvCQ;
import com.ibm.disni.verbs.IbvPd;
import com.ibm.disni.verbs.IbvQP;
import com.ibm.disni.verbs.IbvQPInitAttr;
import com.ibm.jnvmf.KeyedNativeBufferPool;
import com.ibm.jnvmf.NvmfRdmaEndpoint;
import com.ibm.jnvmf.OffHeapMemoryAllocator;
import com.ibm.jnvmf.PdMemoryPool;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

class NvmfRdmaEndpointGroup
extends RdmaEndpointGroup<NvmfRdmaEndpoint> {
    private final Map<BufferPoolKey, PdMemoryPool> bufferPools = new ConcurrentHashMap<BufferPoolKey, PdMemoryPool>();

    public NvmfRdmaEndpointGroup(long timeout, TimeUnit timeoutUnit) throws IOException {
        super((int)TimeUnit.MILLISECONDS.convert(timeout, timeoutUnit));
    }

    public RdmaCqProvider createCqProvider(NvmfRdmaEndpoint endpoint) throws IOException {
        return new RdmaCqProvider(endpoint.getIdPriv().getVerbs(), endpoint.getCqSize());
    }

    public IbvQP createQpProvider(NvmfRdmaEndpoint endpoint) throws IOException {
        IbvQPInitAttr attr = new IbvQPInitAttr();
        attr.cap().setMax_recv_sge(1);
        attr.cap().setMax_recv_wr(endpoint.getRqSize());
        attr.cap().setMax_send_sge(1);
        attr.cap().setMax_send_wr(endpoint.getSqSize());
        attr.cap().setMax_inline_data(endpoint.getInlineDataSize());
        attr.setQp_type((byte)2);
        RdmaCqProvider cqProvider = endpoint.getCqProvider();
        IbvCQ cq = cqProvider.getCQ();
        attr.setRecv_cq(cq);
        attr.setSend_cq(cq);
        IbvQP qp = endpoint.getIdPriv().createQP(endpoint.getPd(), attr);
        if (qp == null) {
            throw new IOException("Create QP failed");
        }
        return qp;
    }

    public void allocateResources(NvmfRdmaEndpoint endpoint) throws Exception {
        endpoint.allocateResources();
    }

    KeyedNativeBufferPool getBufferPool(NvmfRdmaEndpoint endpoint, int size) throws IOException {
        PdMemoryPool prevCommandBufferPool;
        BufferPoolKey key = new BufferPoolKey(endpoint.getPd(), size);
        PdMemoryPool bufferPool = this.bufferPools.get(key);
        if (bufferPool == null && (prevCommandBufferPool = this.bufferPools.putIfAbsent(key, bufferPool = new PdMemoryPool(endpoint.getPd(), new OffHeapMemoryAllocator(), size, 128, 128, ByteOrder.LITTLE_ENDIAN))) != null) {
            bufferPool.free();
            bufferPool = prevCommandBufferPool;
        }
        return bufferPool;
    }

    static class BufferPoolKey {
        private final IbvPd pd;
        private final int size;

        BufferPoolKey(IbvPd pd, int size) {
            this.pd = pd;
            this.size = size;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            BufferPoolKey that = (BufferPoolKey)obj;
            if (this.size != that.size) {
                return false;
            }
            return this.pd.equals(that.pd);
        }

        public int hashCode() {
            int result = this.size;
            result = 31 * result + this.pd.hashCode();
            return result;
        }
    }
}

