/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jnvmf;

import com.ibm.disni.RdmaEndpoint;
import com.ibm.disni.RdmaEndpointGroup;
import com.ibm.disni.verbs.IbvRecvWR;
import com.ibm.disni.verbs.IbvSge;
import com.ibm.disni.verbs.IbvWC;
import com.ibm.disni.verbs.RdmaCmId;
import com.ibm.disni.verbs.RdmaConnParam;
import com.ibm.disni.verbs.SVCPollCq;
import com.ibm.disni.verbs.SVCPostRecv;
import com.ibm.jnvmf.KeyedNativeBuffer;
import com.ibm.jnvmf.KeyedNativeBufferPool;
import com.ibm.jnvmf.NvmfRdmaEndpointGroup;
import com.ibm.jnvmf.RdmaRecv;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.LinkedList;

class NvmfRdmaEndpoint
extends RdmaEndpoint {
    private int cqSize;
    private int rqSize;
    private int sqSize;
    private int inlineDataSize;
    private final RdmaConnParam rdmaConnParam = new RdmaConnParam();
    private RdmaRecv[] rdmaReceives;

    NvmfRdmaEndpoint(NvmfRdmaEndpointGroup group, RdmaCmId idPriv) throws IOException {
        super((RdmaEndpointGroup)group, idPriv, false);
    }

    public synchronized void connect(SocketAddress dst, int timeoutMs) throws Exception {
        if (this.getCqSize() == 0) {
            throw new IllegalArgumentException("CQ size 0");
        }
        if (this.getRqSize() == 0) {
            throw new IllegalArgumentException("RQ size 0");
        }
        if (this.getSqSize() == 0) {
            throw new IllegalArgumentException("SQ size 0");
        }
        super.connect(dst, timeoutMs);
    }

    public RdmaConnParam getConnParam() {
        return this.rdmaConnParam;
    }

    protected synchronized void init() throws IOException {
        super.init();
        this.rdmaReceives = new RdmaRecv[this.getRqSize()];
        KeyedNativeBufferPool responseBufferPool = this.getBufferPool(16);
        for (int i = 0; i < this.getRqSize(); ++i) {
            KeyedNativeBuffer buffer = responseBufferPool.allocate();
            IbvSge recvSge = new IbvSge();
            recvSge.setLkey(buffer.getLocalKey());
            recvSge.setLength(buffer.capacity());
            recvSge.setAddr(buffer.getAddress());
            IbvRecvWR recvWr = new IbvRecvWR();
            recvWr.setWr_id((long)i);
            recvWr.setSg_list(new LinkedList());
            recvWr.getSg_list().add(recvSge);
            recvWr.setNum_sge(1);
            SVCPostRecv postRecv = (SVCPostRecv)this.postRecv(Arrays.asList(recvWr)).execute();
            this.rdmaReceives[i] = new RdmaRecv(postRecv, buffer);
        }
    }

    public RdmaRecv[] getRdmaReceives() {
        return (RdmaRecv[])this.rdmaReceives.clone();
    }

    public void setCqSize(int cqSize) {
        if (cqSize <= 0) {
            throw new IllegalArgumentException("CQ size <= 0");
        }
        this.cqSize = cqSize;
    }

    public int getCqSize() {
        return this.cqSize;
    }

    public int getInlineDataSize() {
        return this.inlineDataSize;
    }

    public void setInlineDataSize(int inlineDataSize) {
        if (inlineDataSize < 0) {
            throw new IllegalArgumentException("Inline data size negative");
        }
        this.inlineDataSize = inlineDataSize;
    }

    public int getRqSize() {
        return this.rqSize;
    }

    public void setRqSize(int rqSize) {
        if (rqSize <= 0) {
            throw new IllegalArgumentException("RQ size <= 0");
        }
        this.rqSize = rqSize;
    }

    public int getSqSize() {
        return this.sqSize;
    }

    public void setSqSize(int sqSize) {
        if (sqSize <= 0) {
            throw new IllegalArgumentException("SQ size <= 0");
        }
        this.sqSize = sqSize;
    }

    private NvmfRdmaEndpointGroup getEndpointGroup() {
        return (NvmfRdmaEndpointGroup)this.group;
    }

    public KeyedNativeBufferPool getBufferPool(int size) throws IOException {
        return this.getEndpointGroup().getBufferPool(this, size);
    }

    public class PollCq
    extends SVCPollCq {
        private final SVCPollCq pollCq;
        private final IbvWC[] wcs;

        public PollCq(int polls) throws IOException {
            this.wcs = new IbvWC[polls];
            for (int i = 0; i < this.wcs.length; ++i) {
                this.wcs[i] = new IbvWC();
            }
            this.pollCq = NvmfRdmaEndpoint.this.getCqProvider().getCQ().poll(this.wcs, this.wcs.length);
        }

        public int getPolls() {
            return this.pollCq.getPolls();
        }

        public SVCPollCq execute() throws IOException {
            return (SVCPollCq)this.pollCq.execute();
        }

        public boolean isValid() {
            return this.pollCq.isValid();
        }

        public SVCPollCq free() {
            return (SVCPollCq)this.pollCq.free();
        }

        public IbvWC[] getWorkCompletions() {
            return this.wcs;
        }
    }
}

