/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jnvmf;

import java.util.Objects;
import java.util.UUID;

public class NvmeQualifiedName {
    private final String nqn;

    public NvmeQualifiedName(String nqn) {
        NvmeQualifiedName.validate(nqn);
        this.nqn = nqn;
    }

    public NvmeQualifiedName(UUID uuid) {
        this.nqn = "nqn.2014-08.org.nvmexpress:uuid:" + uuid.toString();
    }

    private static void validate(String nqn) {
        if (!nqn.matches("nqn\\.\\d{4}-\\d{2}\\.[a-zA-Z0-9.-]*:.*")) {
            throw new IllegalArgumentException("Invalid NQN");
        }
    }

    public String toString() {
        return this.nqn;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NvmeQualifiedName that = (NvmeQualifiedName)obj;
        return Objects.equals(this.nqn, that.nqn);
    }

    public int hashCode() {
        return Objects.hash(this.nqn);
    }
}

