/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jnvmf;

import com.ibm.jnvmf.BitUtil;
import com.ibm.jnvmf.DatasetManagement;
import com.ibm.jnvmf.KeyedSglDataBlockDescriptor;
import com.ibm.jnvmf.NativeBuffer;
import com.ibm.jnvmf.NvmSubmissionQueueEntry;

public abstract class NvmIoCommandSqe
extends NvmSubmissionQueueEntry {
    private static final int STARTING_LBA_OFFSET = 40;
    private static final int NUMBER_OF_LOGICAL_BLOCKS_OFFSET = 48;
    private static final int FORCE_UNIT_ACCESS_OFFSET = 51;
    private static final int FORCE_UNIT_ACCESS_BITOFFSET = 6;
    private static final int LIMITED_RETRY_OFFSET = 51;
    private static final int LIMITED_RETRY_BITOFFSET = 7;
    private static final int DATASET_MANAGEMENT_OFFSET = 52;
    private final KeyedSglDataBlockDescriptor keyedSglDataBlockDescriptor = new KeyedSglDataBlockDescriptor(this.getSglDescriptor1Buffer());
    private final DatasetManagement datasetManagement;

    NvmIoCommandSqe(NativeBuffer buffer) {
        super(buffer);
        this.getBuffer().position(52);
        this.getBuffer().limit(53);
        this.datasetManagement = new DatasetManagement(this.getBuffer().slice());
        this.getBuffer().clear();
    }

    public KeyedSglDataBlockDescriptor getKeyedSglDataBlockDescriptor() {
        return this.keyedSglDataBlockDescriptor;
    }

    public void setStartingLba(long lba) {
        this.getBuffer().putLong(40, lba);
    }

    public void setLimitedRetry(boolean limitedRetry) {
        int raw = this.getBuffer().get(51);
        raw = BitUtil.setBitTo(raw, 7, limitedRetry);
        this.getBuffer().put(51, (byte)raw);
    }

    public void setForceUnitAccess(boolean forceUnitAccess) {
        int raw = this.getBuffer().get(51);
        raw = BitUtil.setBitTo(raw, 6, forceUnitAccess);
        this.getBuffer().put(51, (byte)raw);
    }

    public void setNumberOfLogicalBlocks(int numberOfLogicalBlocks) {
        if (numberOfLogicalBlocks <= 0) {
            throw new IllegalArgumentException("number of logical blocks <= 0");
        }
        if ((numberOfLogicalBlocks & 0xFFFF0000) != 0) {
            throw new IllegalArgumentException("number of logical blocks too large (2 bytes max)");
        }
        this.getBuffer().putShort(48, (short)(numberOfLogicalBlocks - 1));
    }

    public DatasetManagement getDatasetManagement() {
        return this.datasetManagement;
    }
}

