/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jnvmf;

import com.ibm.jnvmf.NativeBuffer;
import com.ibm.jnvmf.NativeData;
import com.ibm.jnvmf.NvmeQualifiedName;
import java.nio.BufferOverflowException;
import java.nio.charset.StandardCharsets;

public class NativeNvmeQualifiedName
extends NativeData<NativeBuffer> {
    public static final int SIZE = 223;

    NativeNvmeQualifiedName(NativeBuffer buffer) {
        super(buffer, 223);
    }

    public void set(NvmeQualifiedName nqn) {
        this.getBuffer().position(0);
        try {
            this.getBuffer().put(StandardCharsets.UTF_8.encode(nqn.toString()));
        }
        catch (BufferOverflowException exception) {
            throw new IllegalArgumentException("NVMe qualified name to large - maximum name is 223 bytes in length");
        }
    }

    NvmeQualifiedName get() {
        this.getBuffer().clear();
        String nqn = StandardCharsets.UTF_8.decode(this.getBuffer().sliceToByteBuffer()).toString();
        nqn = nqn.substring(0, nqn.indexOf(0));
        return new NvmeQualifiedName(nqn);
    }

    @Override
    void initialize() {
    }
}

