/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jnvmf;

import com.ibm.jnvmf.NativeBuffer;
import java.nio.ByteOrder;

abstract class NativeData<B extends NativeBuffer> {
    private final B buffer;

    private final void setOrder() {
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    NativeData(B buffer, int size) {
        if (buffer.remaining() < size) {
            throw new IllegalArgumentException("Buffer size to small");
        }
        buffer.limit(buffer.position() + size);
        this.buffer = buffer.slice();
        this.setOrder();
    }

    abstract void initialize();

    void reset() {
        this.getBuffer().clear();
        while (this.getBuffer().remaining() > 8) {
            this.getBuffer().putLong(0L);
        }
        while (this.getBuffer().remaining() > 0) {
            this.getBuffer().put((byte)0);
        }
        this.initialize();
    }

    B getBuffer() {
        return this.buffer;
    }
}

