/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jnvmf;

import com.ibm.jnvmf.NativeBuffer;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.util.Objects;
import sun.nio.ch.DirectBuffer;

public class NativeByteBuffer
implements NativeBuffer {
    private final ByteBuffer buffer;
    private final long address;

    public NativeByteBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
        this.address = ((DirectBuffer)((Object)buffer)).address();
    }

    protected NativeBuffer construct(ByteBuffer buffer) {
        return new NativeByteBuffer(buffer);
    }

    @Override
    public int position() {
        return this.buffer.position();
    }

    @Override
    public NativeBuffer position(int newPosition) {
        this.buffer.position(newPosition);
        return this;
    }

    @Override
    public int limit() {
        return this.buffer.limit();
    }

    @Override
    public NativeBuffer limit(int newLimit) {
        this.buffer.limit(newLimit);
        return this;
    }

    @Override
    public int remaining() {
        return this.buffer.remaining();
    }

    @Override
    public int capacity() {
        return this.buffer.capacity();
    }

    @Override
    public NativeBuffer clear() {
        this.buffer.clear();
        return this;
    }

    @Override
    public NativeBuffer flip() {
        this.buffer.flip();
        return this;
    }

    @Override
    public NativeBuffer slice() {
        return this.construct(this.buffer.slice());
    }

    @Override
    public ByteBuffer sliceToByteBuffer() {
        return this.buffer.slice();
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return this.buffer;
    }

    @Override
    public ByteOrder order() {
        return this.buffer.order();
    }

    @Override
    public NativeBuffer order(ByteOrder order) {
        this.buffer.order(order);
        return this;
    }

    @Override
    public NativeBuffer putShort(int index, short value) throws IndexOutOfBoundsException, ReadOnlyBufferException {
        this.buffer.putShort(index, value);
        return this;
    }

    @Override
    public NativeBuffer putInt(int index, int value) throws IndexOutOfBoundsException, ReadOnlyBufferException {
        this.buffer.putInt(index, value);
        return this;
    }

    @Override
    public NativeBuffer putLong(int index, long value) throws IndexOutOfBoundsException, ReadOnlyBufferException {
        this.buffer.putLong(index, value);
        return this;
    }

    @Override
    public NativeBuffer putLong(long value) throws BufferOverflowException, ReadOnlyBufferException {
        this.buffer.putLong(value);
        return this;
    }

    @Override
    public NativeBuffer put(int index, byte value) throws IndexOutOfBoundsException, ReadOnlyBufferException {
        this.buffer.put(index, value);
        return this;
    }

    @Override
    public NativeBuffer put(byte value) throws BufferOverflowException, ReadOnlyBufferException {
        this.buffer.put(value);
        return this;
    }

    @Override
    public NativeBuffer put(ByteBuffer src) throws BufferOverflowException, IllegalArgumentException, ReadOnlyBufferException {
        this.buffer.put(src);
        return this;
    }

    @Override
    public NativeBuffer put(byte[] src) throws BufferOverflowException, ReadOnlyBufferException {
        this.buffer.put(src);
        return this;
    }

    @Override
    public byte get(int index) throws BufferUnderflowException {
        return this.buffer.get(index);
    }

    @Override
    public short getShort(int index) throws IndexOutOfBoundsException {
        return this.buffer.getShort(index);
    }

    @Override
    public int getInt(int index) throws IndexOutOfBoundsException {
        return this.buffer.getInt(index);
    }

    @Override
    public long getLong(int index) throws IndexOutOfBoundsException {
        return this.buffer.getLong(index);
    }

    @Override
    public long getAddress() {
        return this.address;
    }

    @Override
    public void free() throws IOException {
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NativeByteBuffer that = (NativeByteBuffer)obj;
        return this.address == that.address && Objects.equals(this.buffer, that.buffer);
    }

    public int hashCode() {
        return Objects.hash(this.buffer, this.address);
    }
}

