/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jnvmf;

import com.ibm.jnvmf.AdminIdentifyCommandSqe;
import com.ibm.jnvmf.AdminIdentifyNamespaceCommand;
import com.ibm.jnvmf.AdminIdentifyNamespaceCommandCapsule;
import com.ibm.jnvmf.CommandFuture;
import com.ibm.jnvmf.Controller;
import com.ibm.jnvmf.IdentifyNamespaceData;
import com.ibm.jnvmf.KeyedNativeBuffer;
import com.ibm.jnvmf.NamespaceIdentifier;
import com.ibm.jnvmf.ResponseFuture;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;

public class Namespace {
    private final Controller controller;
    private final NamespaceIdentifier namespaceIdentifier;
    private final IdentifyNamespaceData identifyNamespaceData;
    private final AdminIdentifyNamespaceCommand command;

    Namespace(Controller controller, NamespaceIdentifier namespaceIdentifier) throws IOException {
        this.controller = controller;
        this.namespaceIdentifier = namespaceIdentifier;
        ByteBuffer buffer = ByteBuffer.allocateDirect(4096);
        KeyedNativeBuffer registeredBuffer = controller.getAdminQueue().registerMemory(buffer);
        this.identifyNamespaceData = new IdentifyNamespaceData(registeredBuffer);
        this.command = new AdminIdentifyNamespaceCommand(controller.getAdminQueue());
        AdminIdentifyNamespaceCommandCapsule commandCapsule = (AdminIdentifyNamespaceCommandCapsule)this.command.getCommandCapsule();
        commandCapsule.setSglDescriptor(this.identifyNamespaceData);
        AdminIdentifyCommandSqe sqe = (AdminIdentifyCommandSqe)commandCapsule.getSubmissionQueueEntry();
        sqe.setNamespaceIdentifier(namespaceIdentifier);
    }

    public boolean isActive() {
        return false;
    }

    public NamespaceIdentifier getIdentifier() {
        return this.namespaceIdentifier;
    }

    public Controller getController() {
        return this.controller;
    }

    private void updateIdentifyNamespaceData() throws IOException {
        CommandFuture commandFuture = this.command.newCommandFuture();
        ResponseFuture responseFuture = this.command.newResponseFuture();
        this.command.execute(responseFuture);
        try {
            commandFuture.get();
            responseFuture.get();
        }
        catch (InterruptedException exception) {
            throw new IOException(exception);
        }
        catch (ExecutionException exception) {
            throw new IOException(exception);
        }
    }

    public IdentifyNamespaceData getIdentifyNamespaceData() throws IOException {
        this.updateIdentifyNamespaceData();
        return this.identifyNamespaceData;
    }
}

