/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jnvmf;

import com.ibm.jnvmf.BitUtil;
import com.ibm.jnvmf.EEnum;
import com.ibm.jnvmf.LbaDataSize;
import com.ibm.jnvmf.NativeBuffer;

public class LbaFormat {
    public static final int SIZE = 4;
    private static final int METADATA_SIZE_OFFSET = 0;
    private static final int LBA_DATA_SIZE_OFFSET = 2;
    private static final int RELATIVE_PERFORMANCE_OFFSET = 3;
    private static final int RELATIVE_PERFORMANCE_BITOFFSET_START = 0;
    private static final int RELATIVE_PERFORMANCE_BITOFFSET_END = 1;
    private final short metaDataSize;
    private final LbaDataSize lbaDataSize;
    private final RelativePerformance.Value relativePerformance;

    LbaFormat(short metaDataSize, byte lbaDataSize, RelativePerformance.Value relativePerformance) {
        this.metaDataSize = metaDataSize;
        this.lbaDataSize = new LbaDataSize(lbaDataSize);
        this.relativePerformance = relativePerformance;
    }

    public short getMetadataSize() {
        return this.metaDataSize;
    }

    public LbaDataSize getLbaDataSize() {
        return this.lbaDataSize;
    }

    public RelativePerformance.Value getRelativePerformance() {
        return this.relativePerformance;
    }

    static LbaFormat fromBuffer(NativeBuffer buffer) {
        short metaDataSize = buffer.getShort(0);
        byte lbaDataSize = buffer.get(2);
        byte raw = buffer.get(3);
        int val = BitUtil.getBits(raw, 0, 1);
        RelativePerformance.Value relativePerformance = (RelativePerformance.Value)RelativePerformance.getInstance().valueOf(val);
        return new LbaFormat(metaDataSize, lbaDataSize, relativePerformance);
    }

    public static class RelativePerformance
    extends EEnum<Value> {
        public final Value BEST_PERFORMANCE = new Value(0);
        public final Value BETTER_PERFORMANCE = new Value(1);
        public final Value GOOD_PERFORMANCE = new Value(2);
        public final Value DEGRADED_PERFORMANCE = new Value(3);
        private static final RelativePerformance instance = new RelativePerformance();

        RelativePerformance() {
            super(3);
        }

        public static RelativePerformance getInstance() {
            return instance;
        }

        public class Value
        extends EEnum.Value {
            Value(int value) {
                super(value);
            }
        }
    }
}

