/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jnvmf;

import com.ibm.jnvmf.KeyedNativeBuffer;
import com.ibm.jnvmf.NativeBuffer;
import com.ibm.jnvmf.ScatterGatherListDescriptor;

public class KeyedSglDataBlockDescriptor
extends ScatterGatherListDescriptor {
    private static final int ADDRESS_OFFSET = 0;
    private static final int LENGTH_OFFSET = 8;
    private static final int KEY_OFFSET = 11;

    KeyedSglDataBlockDescriptor(NativeBuffer buffer) {
        super(buffer);
    }

    private void setSubType(SubType.Value subType) {
        this.setIdentifier(ScatterGatherListDescriptor.Type.getInstance().KEYED_SGL_DATABLOCK, subType);
    }

    public void setAddress(long address) {
        this.setSubType(SubType.getInstance().ADDRESS);
        this.getBuffer().putLong(0, address);
    }

    void invalidateRemoteKey() {
        this.setSubType(SubType.getInstance().INVALIDATE_KEY);
    }

    public void setLength(int length) {
        if ((length & 0xFFFFFF) != length) {
            throw new IllegalArgumentException("Invalid length. Max 3 bytes.");
        }
        int currentOffset = 8;
        this.getBuffer().putShort(currentOffset, (short)length);
        this.getBuffer().put(currentOffset + 2, (byte)(length >>= 16));
    }

    public void setKey(int key) {
        this.getBuffer().putInt(11, key);
    }

    public void set(KeyedNativeBuffer buffer) {
        this.setAddress(buffer.getAddress() + (long)buffer.position());
        this.setLength(buffer.remaining());
        this.setKey(buffer.getRemoteKey());
    }

    @Override
    void initialize() {
    }

    static class SubType
    extends ScatterGatherListDescriptor.SubType {
        public final Value ADDRESS = new Value(0);
        public final Value INVALIDATE_KEY = new Value(15);
        private static final SubType instance = new SubType();

        private SubType() {
        }

        public static SubType getInstance() {
            return instance;
        }

        class Value
        extends ScatterGatherListDescriptor.SubType.Value {
            Value(int value) {
                super(value);
            }
        }
    }
}

