/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jnvmf;

import com.ibm.jnvmf.BitUtil;
import com.ibm.jnvmf.KeyedNativeBuffer;
import com.ibm.jnvmf.LbaFormat;
import com.ibm.jnvmf.NativeData;
import java.util.ArrayList;
import java.util.List;

public class IdentifyNamespaceData
extends NativeData<KeyedNativeBuffer> {
    public static final int SIZE = 4096;
    private static final int NAMESPACE_SIZE_OFFSET = 0;
    private static final int NAMESPACE_CAPACITY_OFFSET = 8;
    private static final int NAMESPACE_UTILIZATION_OFFSET = 16;
    private static final int NAMESPACE_FEATURES_OFFSET = 24;
    private static final int NUMBER_OF_LBA_FORMATS_OFFSET = 25;
    private static final int FORMATTED_LBA_SIZE_OFFSET = 26;
    private static final int FORMATTED_LBA_SIZE_BITOFFSET_START = 0;
    private static final int FORMATTED_LBA_SIZE_BITOFFSET_END = 3;
    private static final int LBA_FORMAT_0_OFFSET = 128;
    private static final int MAX_LBA_FORMATS = 16;
    private final List<LbaFormat> lbaFormats = new ArrayList<LbaFormat>(16);

    IdentifyNamespaceData(KeyedNativeBuffer buffer) {
        super(buffer, 4096);
    }

    public long getNamespaceSize() {
        return ((KeyedNativeBuffer)this.getBuffer()).getLong(0);
    }

    public long getNamespaceCapacity() {
        return ((KeyedNativeBuffer)this.getBuffer()).getLong(8);
    }

    public long getNamespaceUtilization() {
        return ((KeyedNativeBuffer)this.getBuffer()).getLong(16);
    }

    private byte getNumberOfLbaFormats() {
        byte raw = ((KeyedNativeBuffer)this.getBuffer()).get(25);
        if (raw > 16 || raw < 0) {
            throw new IllegalStateException("invalid number of LBA formats");
        }
        return (byte)(raw + 1);
    }

    private void updateLbaFormats() {
        this.lbaFormats.clear();
        int numberOfLbaFormats = this.getNumberOfLbaFormats();
        for (int i = 0; i < numberOfLbaFormats; ++i) {
            int newPosition = 128 + 4 * i;
            ((KeyedNativeBuffer)this.getBuffer()).limit(newPosition + 4);
            ((KeyedNativeBuffer)this.getBuffer()).position(newPosition);
            this.lbaFormats.add(LbaFormat.fromBuffer(((KeyedNativeBuffer)this.getBuffer()).slice()));
        }
        ((KeyedNativeBuffer)this.getBuffer()).clear();
    }

    public List<LbaFormat> getSupportedLbaFormats() {
        this.updateLbaFormats();
        return this.lbaFormats;
    }

    private int getFormattedLbaSizeIndex() {
        byte raw = ((KeyedNativeBuffer)this.getBuffer()).get(26);
        return BitUtil.getBits(raw, 0, 3);
    }

    public LbaFormat getFormattedLbaSize() {
        this.updateLbaFormats();
        return this.lbaFormats.get(this.getFormattedLbaSizeIndex());
    }

    @Override
    void initialize() {
    }
}

