/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jnvmf;

import com.ibm.jnvmf.BitUtil;
import com.ibm.jnvmf.ControllerCapabilities;
import com.ibm.jnvmf.ControllerId;
import com.ibm.jnvmf.KeyedNativeBuffer;
import com.ibm.jnvmf.MemoryPageUnitSize;
import com.ibm.jnvmf.NativeData;
import com.ibm.jnvmf.NvmeVersion;
import com.ibm.jnvmf.Pow2Size;
import com.ibm.jnvmf.QueueEntrySize;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public final class IdentifyControllerData
extends NativeData<KeyedNativeBuffer> {
    public static final int SIZE = 4096;
    private static final int PCI_VENDOR_ID_OFFSET = 0;
    private static final int PCI_SUBSYSTEM_VENDOR_ID_OFFSET = 2;
    private static final int SERIAL_NUMBER_OFFSET = 4;
    private static final int SERIAL_NUMBER_LENGTH = 20;
    private static final int MODEL_NUMBER_OFFSET = 24;
    private static final int MODEL_NUMBER_LENGTH = 40;
    private static final int FIRMWARE_REVISION_OFFSET = 64;
    private static final int FIRMWARE_REVISION_LENGTH = 8;
    private static final int MAXIMUM_DATA_TRANSFER_SIZE_OFFSET = 77;
    private static final int CONTROLLER_ID_OFFSET = 78;
    private static final int VERSION_OFFSET = 80;
    private static final int SUBMISSION_QUEUE_ENTRY_SIZE = 512;
    private static final int REQUIRED_SQE_ENTRY_SIZE_BITOFFSET_START = 0;
    private static final int REQUIRED_SQE_ENTRY_SIZE_BITOFFSET_END = 3;
    private static final int MAXIMUM_SQE_ENTRY_SIZE_BITOFFSET_START = 4;
    private static final int MAXIMUM_SQE_ENTRY_SIZE_BITOFFSET_END = 7;
    private static final int COMPLETION_QUEUE_ENTRY_SIZE = 513;
    private static final int REQUIRED_CQE_ENTRY_SIZE_BITOFFSET_START = 0;
    private static final int REQUIRED_CQE_ENTRY_SIZE_BITOFFSET_END = 3;
    private static final int MAXIMUM_CQE_ENTRY_SIZE_BITOFFSET_START = 4;
    private static final int MAXIMUM_CQE_ENTRY_SIZE_BITOFFSET_END = 7;
    private static final int IO_QUEUE_COMMAND_CAPSULE_SUPPORTED_SIZE_OFFSET = 1792;
    private static final int IO_QUEUE_RESPONSE_CAPSULE_SUPPORTED_SIZE_OFFSET = 1796;
    private static final int IN_CAPSULE_DATA_OFFSET_OFFSET = 1800;
    private static final int CONTROLLER_ATTRIBUTTES_OFFSET = 1802;
    private static final int MAXIMUM_SGL_DATA_BLOCK_DESCRIPTORS_OFFSET = 1803;
    private final ByteBuffer serialNumberBuffer = this.sliceBuffer(4, 20);
    private final ByteBuffer modelNumberBuffer = this.sliceBuffer(24, 40);
    private final ByteBuffer firmwareRevisionBuffer = this.sliceBuffer(64, 8);
    private final NvmeVersion nvmeVersion;
    private final ControllerCapabilities controllerCapabilities;

    private ByteBuffer sliceBuffer(int offset, int length) {
        ((KeyedNativeBuffer)this.getBuffer()).position(offset);
        ((KeyedNativeBuffer)this.getBuffer()).limit(((KeyedNativeBuffer)this.getBuffer()).position() + length);
        ByteBuffer buffer = ((KeyedNativeBuffer)this.getBuffer()).sliceToByteBuffer();
        ((KeyedNativeBuffer)this.getBuffer()).clear();
        return buffer;
    }

    private String decode(ByteBuffer buffer) {
        return StandardCharsets.US_ASCII.decode(buffer).toString().trim();
    }

    IdentifyControllerData(KeyedNativeBuffer buffer, ControllerCapabilities controllerCapabilities) {
        super(buffer, 4096);
        ((KeyedNativeBuffer)this.getBuffer()).position(80);
        ((KeyedNativeBuffer)this.getBuffer()).limit(((KeyedNativeBuffer)this.getBuffer()).position() + 4);
        this.nvmeVersion = new NvmeVersion(((KeyedNativeBuffer)this.getBuffer()).slice());
        ((KeyedNativeBuffer)this.getBuffer()).clear();
        this.controllerCapabilities = controllerCapabilities;
    }

    public short getPciVendorId() {
        return ((KeyedNativeBuffer)this.getBuffer()).getShort(0);
    }

    public short getPciSubsystemVendorId() {
        return ((KeyedNativeBuffer)this.getBuffer()).getShort(2);
    }

    public String getSerialNumber() {
        this.serialNumberBuffer.clear();
        return this.decode(this.serialNumberBuffer);
    }

    public String getModelNumber() {
        this.modelNumberBuffer.clear();
        return this.decode(this.modelNumberBuffer);
    }

    public String getFirmwareRevision() {
        this.firmwareRevisionBuffer.clear();
        return this.decode(this.firmwareRevisionBuffer);
    }

    public MemoryPageUnitSize getMaximumDataTransferSize() {
        byte mdts = ((KeyedNativeBuffer)this.getBuffer()).get(77);
        if (mdts == 0) {
            return MemoryPageUnitSize.MAX_VALUE;
        }
        return new MemoryPageUnitSize(this.controllerCapabilities.getMemoryPageSizeMinimum().toPow2Size(), new Pow2Size(mdts));
    }

    public ControllerId getControllerId() {
        return ControllerId.valueOf(((KeyedNativeBuffer)this.getBuffer()).getShort(78));
    }

    public NvmeVersion getNvmeVersion() {
        return this.nvmeVersion;
    }

    public QueueEntrySize getRequiredSubmissionQueueEntrySize() {
        byte raw = ((KeyedNativeBuffer)this.getBuffer()).get(512);
        return new QueueEntrySize(BitUtil.getBits(raw, 0, 3));
    }

    public QueueEntrySize getMaximumSubmissionQueueEntrySize() {
        byte raw = ((KeyedNativeBuffer)this.getBuffer()).get(512);
        return new QueueEntrySize(BitUtil.getBits(raw, 4, 7));
    }

    public QueueEntrySize getRequiredCompletionQueueEntrySize() {
        byte raw = ((KeyedNativeBuffer)this.getBuffer()).get(513);
        return new QueueEntrySize(BitUtil.getBits(raw, 0, 3));
    }

    public QueueEntrySize getMaximumCompletionQueueEntrySize() {
        byte raw = ((KeyedNativeBuffer)this.getBuffer()).get(513);
        return new QueueEntrySize(BitUtil.getBits(raw, 4, 7));
    }

    public long getIoQueueCommandCapsuleSupportedSize() {
        return (long)((KeyedNativeBuffer)this.getBuffer()).getInt(1792) * 16L;
    }

    public long getIoQueueResponseCapsuleSupportedSize() {
        return (long)((KeyedNativeBuffer)this.getBuffer()).getInt(1796) * 16L;
    }

    public int getInCapsuleDataOffset() {
        return ((KeyedNativeBuffer)this.getBuffer()).getShort(1800) * 16;
    }

    public boolean isStaticController() {
        return BitUtil.getBit(((KeyedNativeBuffer)this.getBuffer()).get(1802), 0);
    }

    public byte getMaximumSglDataBlockDescriptors() {
        return ((KeyedNativeBuffer)this.getBuffer()).get(1803);
    }

    @Override
    void initialize() {
    }
}

