/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jnvmf;

import com.ibm.jnvmf.NativeBuffer;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

final class FabricsHostIdentifier {
    public static final int SIZE = 16;
    private byte[] identifier;
    private static FabricsHostIdentifier fabricsHostIdentifier;

    private FabricsHostIdentifier() {
    }

    public void get(NativeBuffer buffer) {
        if (buffer.remaining() < 16) {
            throw new IllegalArgumentException("buffer to small");
        }
        if (this.identifier == null) {
            try {
                Enumeration<NetworkInterface> networkInterfaceEnumeration = NetworkInterface.getNetworkInterfaces();
                while (networkInterfaceEnumeration.hasMoreElements() && this.identifier == null) {
                    NetworkInterface networkInterface = networkInterfaceEnumeration.nextElement();
                    this.identifier = networkInterface.getHardwareAddress();
                }
                if (this.identifier == null) {
                    throw new SocketException();
                }
            }
            catch (SocketException exception) {
                System.err.println("WARN: Could not get MAC address for host identifier");
                exception.printStackTrace();
                this.identifier = new byte[]{18, 52, 86, 120};
            }
        }
        buffer.put(this.identifier);
    }

    static FabricsHostIdentifier getInstance() {
        if (fabricsHostIdentifier == null) {
            fabricsHostIdentifier = new FabricsHostIdentifier();
        }
        return fabricsHostIdentifier;
    }
}

