/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jnvmf;

import com.ibm.jnvmf.BitUtil;
import com.ibm.jnvmf.ControllerId;
import com.ibm.jnvmf.FabricsCommandStatusCode;
import com.ibm.jnvmf.FabricsCompletionQueueEntry;
import com.ibm.jnvmf.GenericStatusCode;
import com.ibm.jnvmf.NativeBuffer;
import com.ibm.jnvmf.StatusCode;
import com.ibm.jnvmf.Updatable;

public class FabricsConnectResponseCqe
extends FabricsCompletionQueueEntry {
    private final Success success = new Success();
    private final InvalidParameter invalidParameter = new InvalidParameter();

    FabricsConnectResponseCqe() {
    }

    public Success success() {
        StatusCode.Value statusCode = this.getStatusCode();
        if (statusCode != GenericStatusCode.getInstance().SUCCESS) {
            throw new IllegalStateException("Fabrics connect command was not successful but was\nCode: " + statusCode.toInt() + " - " + statusCode.getDescription());
        }
        return this.success;
    }

    public InvalidParameter invalidParameter() {
        StatusCode.Value statusCode = this.getStatusCode();
        if (statusCode != FabricsCommandStatusCode.getInstance().CONNECT_INVALID_PARAMETERS) {
            throw new IllegalStateException("Status code was not invalid parameter but\nCode: " + statusCode.toInt() + " - " + statusCode.getDescription());
        }
        return this.invalidParameter;
    }

    @Override
    void update(NativeBuffer buffer) {
        super.update(buffer);
        StatusCode.Value statusCode = this.getStatusCode();
        if (statusCode == GenericStatusCode.getInstance().SUCCESS) {
            this.success.update(buffer);
        } else if (statusCode == FabricsCommandStatusCode.getInstance().CONNECT_INVALID_PARAMETERS) {
            this.invalidParameter.update(buffer);
        }
    }

    static class InvalidParameter
    extends Updatable<NativeBuffer> {
        private static final int INVALID_PARAMETER_OFFSET = 0;
        private static final int INVALID_ATTRIBUTES = 2;

        InvalidParameter() {
        }

        short getInvalidParameterOffset() {
            return 0;
        }

        @Override
        void update(NativeBuffer buffer) {
        }
    }

    static class Success
    extends Updatable<NativeBuffer> {
        private static final int CONTROLLER_ID_OFFSET = 0;
        private ControllerId controllerId;
        private static final int AUTHENTICATION_REQUIREMENTS_OFFSET = 2;
        private boolean tcgSecurityProtocols;

        Success() {
        }

        ControllerId getControllerId() {
            return this.controllerId;
        }

        boolean usesTcgSecurityProtocols() {
            return this.tcgSecurityProtocols;
        }

        @Override
        void update(NativeBuffer buffer) {
            short contId = buffer.getShort(0);
            this.controllerId = ControllerId.valueOf(contId);
            byte auth = buffer.get(2);
            this.tcgSecurityProtocols = BitUtil.getBit(auth, 0);
        }
    }
}

