/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jnvmf;

import com.ibm.jnvmf.FabricsCommandType;
import com.ibm.jnvmf.FabricsSubmissionQueueEntry;
import com.ibm.jnvmf.KeyedSglDataBlockDescriptor;
import com.ibm.jnvmf.NativeBuffer;
import com.ibm.jnvmf.QueueId;
import java.util.concurrent.TimeUnit;

public final class FabricsConnectCommandSqe
extends FabricsSubmissionQueueEntry {
    private static final int RECORD_FORMAT_OFFSET = 40;
    private static final int QUEUE_ID_OFFSET = 42;
    private static final int SUBMISSION_QUEUE_SIZE_OFFSET = 44;
    private static final int CONNECT_ATTRIBUTES_OFFSET = 46;
    private static final int KEEP_ALIVE_TIMEOUT_OFFSET = 48;
    private final KeyedSglDataBlockDescriptor keyedSglDataBlockDescriptor = new KeyedSglDataBlockDescriptor(this.getSglDescriptor1Buffer());

    FabricsConnectCommandSqe(NativeBuffer buffer) {
        super(buffer);
    }

    KeyedSglDataBlockDescriptor getKeyedSglDataBlockDescriptor() {
        return this.keyedSglDataBlockDescriptor;
    }

    public void setQueueId(QueueId queueId) {
        this.getBuffer().putShort(42, queueId.toShort());
    }

    public void setSubmissionQueueSize(short submissionQueueSize) {
        this.getBuffer().putShort(44, submissionQueueSize);
    }

    public void setKeepAliveTimeout(long duration, TimeUnit unit) {
        long millis = TimeUnit.MILLISECONDS.convert(duration, unit);
        this.getBuffer().putInt(48, Math.toIntExact(millis));
    }

    @Override
    FabricsCommandType getCommandType() {
        return FabricsCommandType.CONNECT;
    }

    @Override
    void initialize() {
        super.initialize();
        this.setKeepAliveTimeout(2L, TimeUnit.MINUTES);
    }
}

