/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jnvmf;

import com.ibm.jnvmf.ControllerId;
import com.ibm.jnvmf.FabricsHostIdentifier;
import com.ibm.jnvmf.KeyedNativeBuffer;
import com.ibm.jnvmf.NativeBuffer;
import com.ibm.jnvmf.NativeData;
import com.ibm.jnvmf.NativeNvmeQualifiedName;
import com.ibm.jnvmf.NvmeQualifiedName;

public class FabricsConnectCommandData
extends NativeData<KeyedNativeBuffer> {
    public static final int SIZE = 1024;
    private static final int HOST_IDENTIFIER_OFFSET = 0;
    private static final int CONTROLLER_ID_OFFSET = 16;
    private static final int SUBSYSTEM_NVME_QUALIFIED_NAME_OFFSET = 256;
    private static final int HOST_NVME_QUALIFIED_NAME_OFFSET = 512;
    private final NativeNvmeQualifiedName subsystemNvmeQualifiedName;
    private final NativeNvmeQualifiedName hostNvmeQualifiedName;

    FabricsConnectCommandData(KeyedNativeBuffer buffer) {
        super(buffer, 1024);
        buffer.position(256);
        this.subsystemNvmeQualifiedName = new NativeNvmeQualifiedName(buffer);
        buffer.clear();
        buffer.position(512);
        this.hostNvmeQualifiedName = new NativeNvmeQualifiedName(buffer);
        buffer.clear();
    }

    void setControllerId(ControllerId controllerId) {
        ((KeyedNativeBuffer)this.getBuffer()).putShort(16, controllerId.toShort());
    }

    void setSubsystemNvmeQualifiedName(NvmeQualifiedName nvmeQualifiedName) {
        this.subsystemNvmeQualifiedName.set(nvmeQualifiedName);
    }

    void setHostNvmeQualifiedName(NvmeQualifiedName nvmeQualifiedName) {
        this.hostNvmeQualifiedName.set(nvmeQualifiedName);
    }

    @Override
    void initialize() {
        ((KeyedNativeBuffer)this.getBuffer()).position(0);
        FabricsHostIdentifier.getInstance().get((NativeBuffer)this.getBuffer());
        ((KeyedNativeBuffer)this.getBuffer()).clear();
    }
}

