/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jnvmf;

public abstract class EEnum<T extends Value> {
    private final Value[] table;

    EEnum(int maxValue) {
        if (maxValue < 0) {
            throw new IllegalArgumentException("max value negative");
        }
        this.table = new Value[maxValue + 1];
    }

    public T valueOf(int value) {
        Value enu;
        try {
            enu = this.table[value];
        }
        catch (Exception exception) {
            enu = null;
        }
        if (enu == null) {
            throw new IllegalArgumentException("No enum with value " + value);
        }
        return (T)enu;
    }

    public class Value {
        private final int value;

        Value(int value) {
            this.value = value;
            try {
                if (EEnum.this.table[value] != null) {
                    throw new Exception();
                }
                ((EEnum)EEnum.this).table[value] = this;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception);
            }
        }

        public int toInt() {
            return this.value;
        }

        public byte toByte() {
            return (byte)this.toInt();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !this.getClass().isInstance(obj)) {
                return false;
            }
            Value value1 = (Value)obj;
            return this.value == value1.value;
        }

        public int hashCode() {
            return this.value;
        }
    }
}

