/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jnvmf;

import com.ibm.jnvmf.BitUtil;
import com.ibm.jnvmf.EEnum;
import com.ibm.jnvmf.NativeBuffer;
import com.ibm.jnvmf.NativeData;

public class DatasetManagement
extends NativeData<NativeBuffer> {
    static final int SIZE = 1;
    private static final int ACCESS_FREQUENCY_BITOFFSET_START = 0;
    private static final int ACCESS_FREQUENCY_BITOFFSET_END = 3;
    private static final int ACCESS_LATENCY_BITOFFSET_START = 4;
    private static final int ACCESS_LATENCY_BITOFFSET_END = 5;
    private static final int SEQUENTIAL_REQUEST_BITOFFSET = 6;
    private static final int INCOMPRESSIBLE_BITOFFSET = 7;

    DatasetManagement(NativeBuffer buffer) {
        super(buffer, 1);
    }

    public void setIncompressible(boolean incompressible) {
        int raw = this.getBuffer().get(0);
        raw = BitUtil.setBitTo(raw, 7, incompressible);
        this.getBuffer().put(0, (byte)raw);
    }

    public void setSequentialRequest(boolean sequentialRequest) {
        int raw = this.getBuffer().get(0);
        raw = BitUtil.setBitTo(raw, 6, sequentialRequest);
        this.getBuffer().put(0, (byte)raw);
    }

    public void setAccessLatency(AccessLatency.Value accessLatency) {
        int raw = this.getBuffer().get(0);
        raw = BitUtil.setBitsTo(raw, 4, 5, accessLatency.toInt());
        this.getBuffer().put(0, (byte)raw);
    }

    public void setAccessFrequency(AccessFrequency.Value accessFrequency) {
        int raw = this.getBuffer().get(0);
        raw = BitUtil.setBitsTo(raw, 0, 3, accessFrequency.toInt());
        this.getBuffer().put(0, (byte)raw);
    }

    @Override
    void initialize() {
    }

    public static class AccessFrequency
    extends EEnum<Value> {
        public final Value NO_INFORMATION = new Value(0);
        public final Value TYPICAL = new Value(1);
        public final Value INFREQUENT = new Value(2);
        public final Value INFREQUENT_WRITES_FREQUENT_READS = new Value(3);
        public final Value FREQUENT_WRITES_INFREQUENT_READS = new Value(4);
        public final Value FREQUENT = new Value(5);
        public final Value ONE_TIME_READ = new Value(6);
        public final Value SPECULATIVE_READ = new Value(7);
        public final Value OVERWRITTEN_NEAR_FUTURE = new Value(8);
        private static final AccessFrequency instance = new AccessFrequency();

        private AccessFrequency() {
            super(8);
        }

        public static AccessFrequency getInstance() {
            return instance;
        }

        public class Value
        extends EEnum.Value {
            Value(int value) {
                super(value);
            }
        }
    }

    public static class AccessLatency
    extends EEnum<Value> {
        public final Value NONE = new Value(0);
        public final Value IDLE = new Value(1);
        public final Value NORMAL = new Value(2);
        public final Value LOW = new Value(3);
        private static final AccessLatency instance = new AccessLatency();

        private AccessLatency() {
            super(3);
        }

        public static AccessLatency getInstance() {
            return instance;
        }

        public class Value
        extends EEnum.Value {
            Value(int value) {
                super(value);
            }
        }
    }
}

