/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jnvmf;

import com.ibm.jnvmf.BitUtil;
import com.ibm.jnvmf.EEnum;
import com.ibm.jnvmf.Property;

public class ControllerStatus {
    private static final int BASE_OFFSET = 28;
    public static final Property PROPERTY = new Property(Property.Size.getInstance().FOUR_BYTES, 28);
    private static final int READY_BITOFFSET = 0;
    private static final int FATAL_STATUS_BITOFFSET = 1;
    private static final int SHUTDOWN_STATUS_BITOFFSET_START = 2;
    private static final int SHUTDOWN_STATUS_BITOFFSET_END = 3;
    private static final int NVM_SUBSYSTEM_RESET_OCCURED_BITOFFSET = 4;
    private static final int PROCESSING_PAUSED_BITOFFSET = 5;
    private int value;

    ControllerStatus() {
    }

    void update(int value) {
        this.value = value;
    }

    public boolean isReady() {
        return BitUtil.getBit(this.value, 0);
    }

    public boolean isFatalStatus() {
        return BitUtil.getBit(this.value, 1);
    }

    public ShutdownStatus.Value getShutdownStatus() {
        return (ShutdownStatus.Value)ShutdownStatus.getInstance().valueOf(BitUtil.getBits(this.value, 2, 3));
    }

    public boolean hasNvmSubsystemResetOccured() {
        return BitUtil.getBit(this.value, 4);
    }

    public boolean isProcessingPaused() {
        return BitUtil.getBit(this.value, 5);
    }

    public static class ShutdownStatus
    extends EEnum<Value> {
        public final Value NORMAL_OPERATION = new Value(0);
        public final Value SHUTDOWN_PROCESSING = new Value(1);
        public final Value SHUTDOWN_COMPLETE = new Value(2);
        private static final ShutdownStatus instance = new ShutdownStatus();

        private ShutdownStatus() {
            super(2);
        }

        public static ShutdownStatus getInstance() {
            return instance;
        }

        public class Value
        extends EEnum.Value {
            Value(int value) {
                super(value);
            }
        }
    }
}

