/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jnvmf;

import com.ibm.jnvmf.BitUtil;
import com.ibm.jnvmf.EEnum;
import com.ibm.jnvmf.MemoryPageUnitSize;
import com.ibm.jnvmf.Pow2Size;
import com.ibm.jnvmf.Property;
import com.ibm.jnvmf.QueueEntrySize;

public class ControllerConfiguration {
    private static final int OFFSET = 20;
    public static final Property PROPERTY = new Property(Property.Size.getInstance().FOUR_BYTES, 20);
    private static final int ENABLE_BITOFFSET = 0;
    private static final int MEMORY_PAGE_SIZE_BITOFFSET_START = 11;
    private static final int MEMORY_PAGE_SIZE_BITOFFSET_END = 13;
    private static final int SHUTDOWN_NOTIFICATION_BITOFFSET_START = 14;
    private static final int SHUTDOWN_NOTIFICATION_BITOFFSET_END = 15;
    private static final int IO_SQE_SIZE_BITOFFSET_START = 16;
    private static final int IO_SQE_SIZE_BITOFFSET_END = 19;
    private static final int IO_CQE_SIZE_BITOFFSET_START = 20;
    private static final int IO_CQE_SIZE_BITOFFSET_END = 23;
    private int value;

    ControllerConfiguration() {
    }

    void update(int value) {
        this.value = value;
    }

    public boolean getEnable() {
        return BitUtil.getBit(this.value, 0);
    }

    public void setEnable(boolean enable) {
        this.value = BitUtil.setBitTo(this.value, 0, enable);
    }

    public MemoryPageUnitSize getMemoryPageSize() {
        int mps = BitUtil.getBits(this.value, 11, 13);
        return new MemoryPageUnitSize(new Pow2Size(mps));
    }

    public ShutdownNotification.Value getShutdownNotification() {
        return (ShutdownNotification.Value)ShutdownNotification.getInstance().valueOf(BitUtil.getBits(this.value, 14, 15));
    }

    public void setShutdownNotification(ShutdownNotification.Value shutdownNotification) {
        this.value = BitUtil.setBitsTo(this.value, 14, 15, shutdownNotification.toInt());
    }

    public QueueEntrySize getIoSubmissionQueueEntrySize() {
        return new QueueEntrySize(BitUtil.getBits(this.value, 16, 19));
    }

    public void setIoSubmissionQueueEntrySize(QueueEntrySize size) {
        this.value = BitUtil.setBitsTo(this.value, 16, 19, size.value());
    }

    public QueueEntrySize getIoCompletionQueueEntrySize() {
        return new QueueEntrySize(BitUtil.getBits(this.value, 20, 23));
    }

    public void setIoCompletionQueueEntrySize(QueueEntrySize size) {
        this.value = BitUtil.setBitsTo(this.value, 20, 23, size.value());
    }

    int toInt() {
        return this.value;
    }

    public static class ShutdownNotification
    extends EEnum<Value> {
        public final Value NO_NOTIFICATION = new Value(0);
        public final Value NORMAL_SHUTDOWN = new Value(1);
        public final Value ABRUPT_SHUTDOWN = new Value(2);
        private static final ShutdownNotification instance = new ShutdownNotification();

        private ShutdownNotification() {
            super(2);
        }

        public static ShutdownNotification getInstance() {
            return instance;
        }

        public class Value
        extends EEnum.Value {
            Value(int value) {
                super(value);
            }
        }
    }
}

