/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jnvmf;

import com.ibm.jnvmf.BitUtil;
import com.ibm.jnvmf.EEnum;
import com.ibm.jnvmf.MemoryPageUnitSize;
import com.ibm.jnvmf.Pow2Size;
import com.ibm.jnvmf.Property;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ControllerCapabilities {
    private static final int OFFSET = 0;
    public static final Property PROPERTY = new Property(Property.Size.getInstance().EIGHT_BYTES, 0);
    private static final int MAXIMUM_QUEUE_ENTRIES_SUPPORTED_BITOFFSET_START = 0;
    private static final int MAXIMUM_QUEUE_ENTRIES_SUPPORTED_BITOFFSET_END = 15;
    private static final int CONTIGUOUS_QUEUE_ENTRIES_REQUIRED_BITOFFSET = 16;
    private static final int ARBITRATION_MECHANISM_SUPPORTED_BITOFFSET_START = 17;
    private static final int ARBITRATION_MECHANISM_SUPPORTED_BITOFFSET_END = 18;
    private static final int TIMEOUT_BITOFFSET_START = 24;
    private static final int TIMEOUT_BITOFFSET_END = 31;
    private static final int NVM_SUBSYSTEM_RESET_SUPPORTED_BITOFFSET = 36;
    private static final int BOOT_PARTITION_SUPPORT_BITOFFSET = 45;
    private static final int MEMORY_PAGE_SIZE_MINIMUM_BITOFFSET_START = 48;
    private static final int MEMORY_PAGE_SIZE_MINIMUM_BITOFFSET_END = 51;
    private static final int MEMORY_PAGE_SIZE_MAXIMUM_BITOFFSET_START = 52;
    private static final int MEMORY_PAGE_SIZE_MAXIMUM_BITOFFSET_END = 55;
    private long value;

    ControllerCapabilities() {
    }

    void update(long value) {
        this.value = value;
    }

    public long getMaximumQueueEntriesSupported() {
        return BitUtil.getBits(this.value, 0, 15) + 1L;
    }

    public boolean getContiguousQueuesRequired() {
        return BitUtil.getBit(this.value, 16);
    }

    public List<ArbitrationMechanism.Value> getArbitrationMechanismSupported() {
        long ams = (int)BitUtil.getBits(this.value, 17, 18);
        ArrayList<ArbitrationMechanism.Value> arbitrationMechanismList = new ArrayList<ArbitrationMechanism.Value>(2);
        if ((ams & (long)ArbitrationMechanism.getInstance().WEIGHTED_ROUND_ROBIN.toInt()) != 0L) {
            arbitrationMechanismList.add(ArbitrationMechanism.getInstance().WEIGHTED_ROUND_ROBIN);
        }
        if ((ams & (long)ArbitrationMechanism.getInstance().VENDOR_SPECIFIC.toInt()) != 0L) {
            arbitrationMechanismList.add(ArbitrationMechanism.getInstance().VENDOR_SPECIFIC);
        }
        return arbitrationMechanismList;
    }

    public long getTimeout() {
        return BitUtil.getBits(this.value, 24, 31) * 500L;
    }

    public static TimeUnit getTimeoutUnit() {
        return TimeUnit.MILLISECONDS;
    }

    public boolean getNvmSubsystemResetSupported() {
        return BitUtil.getBit(this.value, 36);
    }

    public boolean getBootPartitionSupport() {
        return BitUtil.getBit(this.value, 45);
    }

    public MemoryPageUnitSize getMemoryPageSizeMinimum() {
        int mpsMin = (int)BitUtil.getBits(this.value, 48, 51);
        return new MemoryPageUnitSize(new Pow2Size(mpsMin));
    }

    public MemoryPageUnitSize getMemoryPageSizeMaximum() {
        int mpsMax = (int)BitUtil.getBits(this.value, 52, 55);
        return new MemoryPageUnitSize(new Pow2Size(mpsMax));
    }

    public static class ArbitrationMechanism
    extends EEnum<Value> {
        public final Value WEIGHTED_ROUND_ROBIN = new Value(1, "Weighted Round Robin with Urgent Priority Class");
        public final Value VENDOR_SPECIFIC = new Value(2, "Vendor Specific");
        private static final ArbitrationMechanism instance = new ArbitrationMechanism();

        private ArbitrationMechanism() {
            super(2);
        }

        public static ArbitrationMechanism getInstance() {
            return instance;
        }

        public class Value
        extends EEnum.Value {
            private final String description;

            Value(int value, String description) {
                super(value);
                this.description = description;
            }

            public String getDescription() {
                return this.description;
            }
        }
    }
}

