/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jnvmf;

import com.ibm.jnvmf.AdminCompletionQueueEntry;
import com.ibm.jnvmf.AdminIdentifyActiveNamespaceIdsCommand;
import com.ibm.jnvmf.AdminIdentifyActiveNamespacesCommandCapsule;
import com.ibm.jnvmf.AdminIdentifyCommandSqe;
import com.ibm.jnvmf.AdminIdentifyControllerCommand;
import com.ibm.jnvmf.AdminIdentifyControllerCommandCapsule;
import com.ibm.jnvmf.AdminKeepAliveCommand;
import com.ibm.jnvmf.AdminKeepAliveCommandCapsule;
import com.ibm.jnvmf.AdminQueuePair;
import com.ibm.jnvmf.AdminResponseCapsule;
import com.ibm.jnvmf.CommandFuture;
import com.ibm.jnvmf.ControllerCapabilities;
import com.ibm.jnvmf.ControllerConfiguration;
import com.ibm.jnvmf.ControllerId;
import com.ibm.jnvmf.ControllerStatus;
import com.ibm.jnvmf.FabricsCompletionQueueEntry;
import com.ibm.jnvmf.FabricsPropertyGetCommand;
import com.ibm.jnvmf.FabricsPropertyGetCommandCapsule;
import com.ibm.jnvmf.FabricsPropertyGetCommandSqe;
import com.ibm.jnvmf.FabricsPropertyGetResponseCapsule;
import com.ibm.jnvmf.FabricsPropertyGetResponseCqe;
import com.ibm.jnvmf.FabricsPropertySetCommand;
import com.ibm.jnvmf.FabricsPropertySetCommandCapsule;
import com.ibm.jnvmf.FabricsPropertySetCommandSqe;
import com.ibm.jnvmf.FabricsResponseCapsule;
import com.ibm.jnvmf.Freeable;
import com.ibm.jnvmf.GenericStatusCode;
import com.ibm.jnvmf.IdentifyControllerData;
import com.ibm.jnvmf.IoQueuePair;
import com.ibm.jnvmf.KeyedNativeBuffer;
import com.ibm.jnvmf.LegacySupport;
import com.ibm.jnvmf.Namespace;
import com.ibm.jnvmf.NamespaceIdentifier;
import com.ibm.jnvmf.NamespaceIdentifierList;
import com.ibm.jnvmf.NvmeQualifiedName;
import com.ibm.jnvmf.NvmfRdmaEndpointFactory;
import com.ibm.jnvmf.NvmfRdmaEndpointGroup;
import com.ibm.jnvmf.NvmfTransportId;
import com.ibm.jnvmf.Property;
import com.ibm.jnvmf.QueueId;
import com.ibm.jnvmf.QueuePair;
import com.ibm.jnvmf.ResponseFuture;
import com.ibm.jnvmf.UnsuccessfulComandException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class Controller
implements Freeable {
    private short queueId;
    private final AdminQueuePair adminQueue;
    private final List<IoQueuePair> ioQueuePairs;
    private final NvmeQualifiedName hostNvmeQualifiedName;
    private final NvmfTransportId transportId;
    private final NvmfRdmaEndpointGroup endpointGroup;
    private ControllerId controllerId;
    private final ControllerConfiguration controllerConfiguration;
    private final ControllerStatus controllerStatus;
    private final ControllerCapabilities controllerCapabilities;
    private final List<Namespace> namespaces;
    private boolean valid;
    private final AdminKeepAliveCommand keepAliveCommand;
    private final FabricsPropertySetCommand propertySetCommand;
    private final FabricsPropertyGetCommand propertyGetCommand;
    private final AdminIdentifyActiveNamespaceIdsCommand activeNamespaceIdsCommand;
    private NamespaceIdentifierList namespaceIdentifierList;
    private IdentifyControllerData identifyControllerData;

    Controller(NvmeQualifiedName hostNvmeQualifiedName, NvmfTransportId transportId, long connectTimeout, TimeUnit connectTimeoutUnit, boolean dynamicId) throws IOException {
        this.hostNvmeQualifiedName = hostNvmeQualifiedName;
        this.transportId = transportId;
        this.queueId = 1;
        this.endpointGroup = new NvmfRdmaEndpointGroup(connectTimeout, connectTimeoutUnit);
        this.endpointGroup.init(new NvmfRdmaEndpointFactory(this.endpointGroup));
        if (dynamicId) {
            this.setControllerId(ControllerId.ADMIN_DYNAMIC);
        } else {
            this.setControllerId(ControllerId.ADMIN_STATIC);
        }
        this.adminQueue = new AdminQueuePair(this);
        this.ioQueuePairs = new ArrayList<IoQueuePair>();
        this.keepAliveCommand = new AdminKeepAliveCommand(this.getAdminQueue());
        this.propertySetCommand = new FabricsPropertySetCommand(this.getAdminQueue());
        this.propertyGetCommand = new FabricsPropertyGetCommand(this.getAdminQueue());
        this.activeNamespaceIdsCommand = new AdminIdentifyActiveNamespaceIdsCommand(this.getAdminQueue());
        this.controllerConfiguration = new ControllerConfiguration();
        this.controllerCapabilities = new ControllerCapabilities();
        this.controllerCapabilities.update(this.getProperty(ControllerCapabilities.PROPERTY));
        this.controllerStatus = new ControllerStatus();
        this.namespaces = new ArrayList<Namespace>();
        this.valid = true;
    }

    private IdentifyControllerData identifyController() throws IOException {
        AdminResponseCapsule response;
        ByteBuffer dataBuffer = ByteBuffer.allocateDirect(4096);
        KeyedNativeBuffer registeredDataBuffer = this.adminQueue.registerMemory(dataBuffer);
        IdentifyControllerData identifyControllerData = new IdentifyControllerData(registeredDataBuffer, this.controllerCapabilities);
        AdminIdentifyControllerCommand identifyControllerCommand = new AdminIdentifyControllerCommand(this.adminQueue);
        ((AdminIdentifyControllerCommandCapsule)identifyControllerCommand.getCommandCapsule()).setSglDescriptor(identifyControllerData);
        ResponseFuture responseFuture = identifyControllerCommand.newResponseFuture();
        CommandFuture commandFuture = identifyControllerCommand.newCommandFuture();
        identifyControllerCommand.execute(responseFuture);
        try {
            commandFuture.get();
            response = (AdminResponseCapsule)responseFuture.get();
        }
        catch (InterruptedException exception) {
            throw new IOException(exception);
        }
        catch (ExecutionException exception) {
            throw new IOException(exception);
        }
        AdminCompletionQueueEntry cqe = (AdminCompletionQueueEntry)response.getCompletionQueueEntry();
        if (cqe.getStatusCode() != GenericStatusCode.getInstance().SUCCESS) {
            throw new UnsuccessfulComandException(cqe);
        }
        return identifyControllerData;
    }

    public IdentifyControllerData getIdentifyControllerData() throws IOException {
        if (this.identifyControllerData == null) {
            this.identifyControllerData = this.identifyController();
        }
        return this.identifyControllerData;
    }

    public AdminQueuePair getAdminQueue() {
        return this.adminQueue;
    }

    private QueueId nextQueueId() {
        short s = this.queueId;
        this.queueId = (short)(s + 1);
        return new QueueId(s);
    }

    public IoQueuePair createIoQueuePair(int submissionQueueSize) throws IOException {
        return this.createIoQueuePair(submissionQueueSize, 0, 0, 0);
    }

    public IoQueuePair createIoQueuePair(int submissionQueueSize, int additionalSgls, int inCapsuleDataSize, int maxInlineSize) throws IOException {
        if ((submissionQueueSize & 0xFFFF0000) != 0) {
            throw new IllegalArgumentException("Size to large (" + submissionQueueSize + ")");
        }
        if (!this.controllerStatus.isReady() && !this.getControllerStatus().isReady()) {
            throw new IllegalStateException("Controller not ready - enable controller");
        }
        this.getControllerConfiguration();
        if (this.controllerConfiguration.getIoSubmissionQueueEntrySize().value() == 0 || this.controllerConfiguration.getIoCompletionQueueEntrySize().value() == 0) {
            this.controllerConfiguration.setIoSubmissionQueueEntrySize(this.getIdentifyControllerData().getRequiredSubmissionQueueEntrySize());
            this.controllerConfiguration.setIoCompletionQueueEntrySize(this.getIdentifyControllerData().getRequiredCompletionQueueEntrySize());
            this.syncConfiguration();
        }
        IoQueuePair ioQueuePair = new IoQueuePair(this, this.nextQueueId(), (short)submissionQueueSize, additionalSgls, inCapsuleDataSize, maxInlineSize);
        this.ioQueuePairs.add(ioQueuePair);
        return ioQueuePair;
    }

    private void updateNamespacesIdentfiers() throws IOException {
        NamespaceIdentifier namespaceId;
        AdminIdentifyActiveNamespacesCommandCapsule commandCapsule = (AdminIdentifyActiveNamespacesCommandCapsule)this.activeNamespaceIdsCommand.getCommandCapsule();
        if (this.namespaceIdentifierList == null) {
            ByteBuffer buffer = ByteBuffer.allocateDirect(4096);
            KeyedNativeBuffer registeredBuffer = this.getAdminQueue().registerMemory(buffer);
            this.namespaceIdentifierList = new NamespaceIdentifierList(registeredBuffer);
            commandCapsule.setSglDescriptor(this.namespaceIdentifierList);
            AdminIdentifyCommandSqe sqe = (AdminIdentifyCommandSqe)commandCapsule.getSubmissionQueueEntry();
            sqe.setNamespaceIdentifier(new NamespaceIdentifier(0));
        }
        CommandFuture commandFuture = this.activeNamespaceIdsCommand.newCommandFuture();
        ResponseFuture responseFuture = this.activeNamespaceIdsCommand.newResponseFuture();
        this.activeNamespaceIdsCommand.execute(responseFuture);
        try {
            commandFuture.get();
            AdminResponseCapsule response = (AdminResponseCapsule)responseFuture.get();
            AdminCompletionQueueEntry cqe = (AdminCompletionQueueEntry)response.getCompletionQueueEntry();
            if (cqe.getStatusCode() != GenericStatusCode.getInstance().SUCCESS) {
                throw new UnsuccessfulComandException(cqe);
            }
        }
        catch (InterruptedException exception) {
            throw new IOException(exception);
        }
        catch (ExecutionException exception) {
            throw new IOException(exception);
        }
        this.namespaces.clear();
        int i = 0;
        while ((namespaceId = this.namespaceIdentifierList.getIdentifier(i)) != null) {
            this.namespaces.add(new Namespace(this, namespaceId));
            ++i;
        }
    }

    public List<Namespace> getActiveNamespaces() throws IOException {
        this.updateNamespacesIdentfiers();
        return this.namespaces;
    }

    public void keepAlive() throws IOException {
        AdminResponseCapsule responseCapsule;
        CommandFuture commandFuture = this.keepAliveCommand.newCommandFuture();
        ResponseFuture responseFuture = this.keepAliveCommand.newResponseFuture();
        this.keepAliveCommand.execute(responseFuture);
        try {
            commandFuture.get();
            responseCapsule = (AdminResponseCapsule)responseFuture.get();
        }
        catch (InterruptedException exception) {
            throw new IOException(exception);
        }
        catch (ExecutionException exception) {
            throw new IOException(exception);
        }
        AdminCompletionQueueEntry cqe = (AdminCompletionQueueEntry)responseCapsule.getCompletionQueueEntry();
        if (cqe.getStatusCode() != GenericStatusCode.getInstance().SUCCESS) {
            throw new UnsuccessfulComandException(cqe);
        }
    }

    private void setProperty(Property property, long value) throws IOException {
        FabricsResponseCapsule responseCapsule;
        FabricsPropertySetCommandCapsule propertySetCommandCapsule = (FabricsPropertySetCommandCapsule)this.propertySetCommand.getCommandCapsule();
        ((FabricsPropertySetCommandSqe)propertySetCommandCapsule.getSubmissionQueueEntry()).setProperty(property);
        ((FabricsPropertySetCommandSqe)propertySetCommandCapsule.getSubmissionQueueEntry()).setValue(value);
        CommandFuture commandFuture = this.propertySetCommand.newCommandFuture();
        ResponseFuture responseFuture = this.propertySetCommand.newResponseFuture();
        this.propertySetCommand.execute(responseFuture);
        try {
            commandFuture.get();
            responseCapsule = (FabricsResponseCapsule)responseFuture.get();
        }
        catch (InterruptedException exception) {
            throw new IOException(exception);
        }
        catch (ExecutionException exception) {
            throw new IOException(exception);
        }
        FabricsCompletionQueueEntry cqe = (FabricsCompletionQueueEntry)responseCapsule.getCompletionQueueEntry();
        if (cqe.getStatusCode() != GenericStatusCode.getInstance().SUCCESS) {
            throw new UnsuccessfulComandException(cqe);
        }
    }

    private long getProperty(Property property) throws IOException {
        FabricsPropertyGetResponseCapsule responseCapsule;
        FabricsPropertyGetCommandCapsule propertyGetCommandCapsule = (FabricsPropertyGetCommandCapsule)this.propertyGetCommand.getCommandCapsule();
        ((FabricsPropertyGetCommandSqe)propertyGetCommandCapsule.getSubmissionQueueEntry()).setProperty(property);
        CommandFuture commandFuture = this.propertyGetCommand.newCommandFuture();
        ResponseFuture responseFuture = this.propertyGetCommand.newResponseFuture();
        this.propertyGetCommand.execute(responseFuture);
        try {
            commandFuture.get();
            responseCapsule = (FabricsPropertyGetResponseCapsule)responseFuture.get();
        }
        catch (InterruptedException exception) {
            throw new IOException(exception);
        }
        catch (ExecutionException exception) {
            throw new IOException(exception);
        }
        FabricsPropertyGetResponseCqe cqe = (FabricsPropertyGetResponseCqe)responseCapsule.getCompletionQueueEntry();
        if (cqe.getStatusCode() != GenericStatusCode.getInstance().SUCCESS) {
            throw new UnsuccessfulComandException(cqe);
        }
        return cqe.getValue();
    }

    public void syncConfiguration() throws IOException {
        if (LegacySupport.ENABLED) {
            LegacySupport.initializeControllerConfiguration(this.controllerConfiguration);
        }
        this.setProperty(ControllerConfiguration.PROPERTY, this.controllerConfiguration.toInt());
    }

    public void waitUntilReady() throws IOException, TimeoutException {
        ControllerStatus controllerStatus;
        if (!this.getControllerConfiguration().getEnable()) {
            throw new IllegalStateException("Controller not enabled");
        }
        long maxWaitDuration = TimeUnit.NANOSECONDS.convert(this.getControllerCapabilities().getTimeout(), ControllerCapabilities.getTimeoutUnit());
        long maxWaitTime = System.nanoTime() + maxWaitDuration;
        long sleepTime = TimeUnit.MILLISECONDS.convert(this.getControllerCapabilities().getTimeout(), ControllerCapabilities.getTimeoutUnit()) / 10L;
        while (!(controllerStatus = this.getControllerStatus()).isReady()) {
            if (controllerStatus.isFatalStatus()) {
                throw new IOException("Fatal controller error");
            }
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException exception) {
                throw new IOException(exception);
            }
            if (maxWaitTime <= System.nanoTime()) continue;
            throw new TimeoutException("Controller did not become ready in " + this.getControllerCapabilities().getTimeout() + (Object)((Object)ControllerCapabilities.getTimeoutUnit()));
        }
    }

    public NvmfTransportId getTransportId() {
        return this.transportId;
    }

    NvmfRdmaEndpointGroup getEndpointGroup() {
        return this.endpointGroup;
    }

    void setControllerId(ControllerId controllerId) {
        this.controllerId = controllerId;
    }

    public ControllerId getControllerId() {
        return this.controllerId;
    }

    @Override
    public void free() throws IOException {
        this.valid = false;
        try {
            ((AdminKeepAliveCommandCapsule)this.keepAliveCommand.getCommandCapsule()).free();
            ((FabricsPropertySetCommandCapsule)this.propertySetCommand.getCommandCapsule()).free();
            ((FabricsPropertyGetCommandCapsule)this.propertyGetCommand.getCommandCapsule()).free();
            ((AdminIdentifyActiveNamespacesCommandCapsule)this.activeNamespaceIdsCommand.getCommandCapsule()).free();
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
        if (this.identifyControllerData != null) {
            ((KeyedNativeBuffer)this.identifyControllerData.getBuffer()).free();
        }
        this.adminQueue.free();
        for (QueuePair queuePair : this.ioQueuePairs) {
            queuePair.free();
        }
        try {
            this.endpointGroup.close();
        }
        catch (InterruptedException exception) {
            throw new IOException(exception);
        }
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    public ControllerConfiguration getControllerConfiguration() throws IOException {
        this.controllerConfiguration.update((int)this.getProperty(ControllerConfiguration.PROPERTY));
        return this.controllerConfiguration;
    }

    public ControllerStatus getControllerStatus() throws IOException {
        this.controllerStatus.update((int)this.getProperty(ControllerStatus.PROPERTY));
        return this.controllerStatus;
    }

    public ControllerCapabilities getControllerCapabilities() {
        return this.controllerCapabilities;
    }

    public NvmeQualifiedName getHostNvmeQualifiedName() {
        return this.hostNvmeQualifiedName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Controller that = (Controller)obj;
        return Objects.equals(this.controllerId, that.controllerId);
    }

    public int hashCode() {
        return Objects.hash(this.controllerId);
    }
}

