/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jnvmf;

import com.ibm.jnvmf.BitUtil;
import com.ibm.jnvmf.NativeBuffer;
import com.ibm.jnvmf.StatusCode;
import com.ibm.jnvmf.StatusCodeType;
import com.ibm.jnvmf.Updatable;
import java.nio.ByteOrder;

abstract class CompletionQueueEntry
extends Updatable<NativeBuffer> {
    public static final int SIZE = 16;
    private static final int SUBMISSION_QUEUE_HEAD_POINTER_OFFSET = 8;
    private short submissionQueueHeadPointer;
    private static final int COMMAND_IDENTIFIER_OFFSET = 12;
    private short commandIdentifier;
    private static final int STATUS_CODE_OFFSET = 14;
    private static final int STATUS_CODE_TYPE_OFFSET = 15;
    private StatusCodeType.Value statusCodeType;
    private static final int MORE_OFFSET = 15;
    private static final int MORE_BITOFFSET = 6;
    private boolean more;
    private static final int DO_NOT_RETRY_OFFSET = 15;
    private static final int DO_NOT_RETRY_BITOFFSET = 7;
    private boolean doNotRetry;

    CompletionQueueEntry() {
    }

    public final short getSubmissionQueueHeadPointer() {
        return this.submissionQueueHeadPointer;
    }

    public final short getCommandIdentifier() {
        return this.commandIdentifier;
    }

    static short getCommandIdentifier(NativeBuffer buffer) {
        return buffer.getShort(12);
    }

    int getStatusCodeRaw(NativeBuffer buffer) {
        short raw = buffer.getShort(14);
        return BitUtil.getBits(raw, 1, 8);
    }

    public abstract StatusCode.Value getStatusCode();

    public final StatusCodeType.Value getStatusCodeType() {
        return this.statusCodeType;
    }

    public final boolean getMore() {
        return this.more;
    }

    public final boolean getDoNotRetry() {
        return this.doNotRetry;
    }

    @Override
    void update(NativeBuffer buffer) {
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.submissionQueueHeadPointer = buffer.getShort(8);
        this.commandIdentifier = CompletionQueueEntry.getCommandIdentifier(buffer);
        byte b1 = buffer.get(15);
        this.statusCodeType = (StatusCodeType.Value)StatusCodeType.getInstance().valueOf(BitUtil.getBits(b1, 1, 3));
        this.more = BitUtil.getBit(b1, 6);
        this.doNotRetry = BitUtil.getBit(b1, 7);
    }
}

