/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jnvmf;

abstract class CommandType {
    private static final int GENERIC_COMMAND_OFFSET = 7;
    private static final int FUNCTION_OFFSET = 2;
    private static final int DATA_TRANSFER_OFFSET = 0;
    private final byte opcode;
    private final boolean admin;

    protected CommandType(boolean generic, int function, DataTransfer dataTransfer, boolean admin) {
        int opcode = dataTransfer.getValue();
        opcode |= function << 2;
        if (generic) {
            opcode = 128;
        }
        this.opcode = (byte)opcode;
        this.admin = admin;
    }

    byte toByte() {
        return this.opcode;
    }

    boolean adminQueueOnly() {
        return this.admin;
    }

    static enum DataTransfer {
        NO(0),
        HOST_TO_CONTROLLER(1),
        CONTROLLER_TO_HOST(2),
        BIDIRECTIONAL(3);

        private final int value;

        private DataTransfer(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }
}

