/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jnvmf;

import com.ibm.jnvmf.Freeable;
import com.ibm.jnvmf.KeyedNativeBuffer;
import com.ibm.jnvmf.NativeBuffer;
import com.ibm.jnvmf.NativeData;
import com.ibm.jnvmf.ScatterGatherListDescriptor;
import com.ibm.jnvmf.SubmissionQueueEntry;
import com.ibm.jnvmf.SubmissionQueueEntryFactory;
import java.io.IOException;

public abstract class CommandCapsule<SqeT extends SubmissionQueueEntry>
extends NativeData<KeyedNativeBuffer>
implements Freeable {
    private final SqeT submissionQueueEntry;
    private final NativeBuffer data;
    private final int incapsuleDataOffset;
    private final ScatterGatherListDescriptor[] additionalSgls;

    CommandCapsule(KeyedNativeBuffer buffer, SubmissionQueueEntryFactory<SqeT> sqeFactory) {
        this(buffer, sqeFactory, 0, 0, 0);
    }

    static int computeCommandCapsuleSize(int additionalSgls, int incapsuleDataOffset, int incapsuleDataSize) {
        int maxCommandCapsuleSize = 64 + additionalSgls * 16;
        if (incapsuleDataSize > 0) {
            try {
                maxCommandCapsuleSize = Math.max(Math.addExact(64 + incapsuleDataOffset, incapsuleDataSize), maxCommandCapsuleSize);
            }
            catch (ArithmeticException exception) {
                throw new IllegalArgumentException("Incapsule data size too large (integer overflow)");
            }
        }
        return maxCommandCapsuleSize;
    }

    CommandCapsule(KeyedNativeBuffer buffer, SubmissionQueueEntryFactory<SqeT> sqeFactory, int additionalSgls, int incapsuleDataOffset, int incapsuleDataSize) {
        super(buffer, CommandCapsule.computeCommandCapsuleSize(additionalSgls, incapsuleDataOffset, incapsuleDataSize));
        this.submissionQueueEntry = sqeFactory.construct(this.getBuffer());
        ((SubmissionQueueEntry)this.submissionQueueEntry).initialize();
        this.incapsuleDataOffset = incapsuleDataOffset;
        if (incapsuleDataSize > 0) {
            this.getBuffer().position(64 + incapsuleDataOffset);
            this.getBuffer().limit(this.getBuffer().position() + incapsuleDataSize);
            this.data = this.getBuffer().slice();
            this.getBuffer().clear();
        } else {
            this.data = null;
        }
        this.additionalSgls = new ScatterGatherListDescriptor[additionalSgls];
    }

    int getIncapsuleDataOffset() {
        return this.incapsuleDataOffset;
    }

    public SqeT getSubmissionQueueEntry() {
        return this.submissionQueueEntry;
    }

    NativeBuffer getIncapsuleData() {
        if (this.data == null) {
            throw new IllegalStateException("Command does not support incasule data or not enough space");
        }
        return this.data;
    }

    @Override
    void initialize() {
        ((SubmissionQueueEntry)this.submissionQueueEntry).initialize();
    }

    @Override
    KeyedNativeBuffer getBuffer() {
        return (KeyedNativeBuffer)super.getBuffer();
    }

    @Override
    public void free() throws IOException {
        this.getBuffer().free();
    }

    @Override
    public boolean isValid() {
        return this.getBuffer().isValid();
    }
}

