/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jnvmf;

import com.ibm.disni.verbs.IbvSendWR;
import com.ibm.disni.verbs.IbvSge;
import com.ibm.disni.verbs.SVCPostSend;
import com.ibm.jnvmf.CommandCapsule;
import com.ibm.jnvmf.CommandFuture;
import com.ibm.jnvmf.KeyedNativeBuffer;
import com.ibm.jnvmf.Operation;
import com.ibm.jnvmf.QueuePair;
import com.ibm.jnvmf.Response;
import com.ibm.jnvmf.ResponseCapsule;
import com.ibm.jnvmf.ResponseFuture;
import com.ibm.jnvmf.SubmissionQueueEntry;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;

public abstract class Command<C extends CommandCapsule, R extends ResponseCapsule>
extends Operation {
    private final QueuePair queuePair;
    private final C commandCapsule;
    private final IbvSendWR wr;
    private SVCPostSend postSend;

    Command(QueuePair queuePair, C commandCapsule) {
        this.queuePair = queuePair;
        this.commandCapsule = commandCapsule;
        KeyedNativeBuffer buffer = ((CommandCapsule)commandCapsule).getBuffer();
        IbvSge sge = new IbvSge();
        sge.setAddr(buffer.getAddress());
        sge.setLength(buffer.remaining());
        sge.setLkey(buffer.getLocalKey());
        LinkedList<IbvSge> sgList = new LinkedList<IbvSge>();
        sgList.add(sge);
        this.wr = new IbvSendWR();
        this.wr.setSg_list(sgList);
        this.wr.setNum_sge(1);
        this.wr.setOpcode(IbvSendWR.IbvWrOcode.IBV_WR_SEND.ordinal());
        this.wr.setSend_flags(IbvSendWR.IBV_SEND_SIGNALED);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSendInline(boolean sendInline) {
        if (sendInline) {
            LinkedList sgList = this.wr.getSg_list();
            long size = 0L;
            for (IbvSge sge : sgList) {
                size += (long)sge.getLength();
            }
            if ((long)this.getQueuePair().getInlineDataSize() < size) throw new IllegalArgumentException("Insufficient inline data size");
            this.wr.setSend_flags(this.wr.getSend_flags() | IbvSendWR.IBV_SEND_INLINE);
            return;
        } else {
            this.wr.setSend_flags(this.wr.getSend_flags() & ~IbvSendWR.IBV_SEND_INLINE);
        }
    }

    private SVCPostSend getPostSend() throws IOException {
        if (this.postSend == null) {
            this.postSend = this.getQueuePair().newPostSend(Arrays.asList(this.wr));
        }
        return this.postSend;
    }

    public Response<R> execute(Response<R> response) throws IOException {
        this.getQueuePair().post(this, this.getPostSend(), response);
        return response;
    }

    public ResponseFuture<R> execute(ResponseFuture<R> responseFuture) throws IOException {
        this.getQueuePair().post(this, this.getPostSend(), (Response)responseFuture.getOperation());
        return responseFuture;
    }

    public abstract Response<R> newResponse();

    public ResponseFuture<R> newResponseFuture() {
        return new ResponseFuture<R>(this.getQueuePair(), this.newResponse());
    }

    public CommandFuture<C, R> newCommandFuture() {
        return new CommandFuture(this.getQueuePair(), this);
    }

    void setCommandId(short commandId) {
        ((SubmissionQueueEntry)((CommandCapsule)this.commandCapsule).getSubmissionQueueEntry()).setCommandIdentifier(commandId);
    }

    public QueuePair getQueuePair() {
        return this.queuePair;
    }

    public C getCommandCapsule() {
        return this.commandCapsule;
    }
}

