/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jnvmf;

class BitUtil {
    BitUtil() {
    }

    private static void checkBounds(int position, int limit) {
        if (position < 0) {
            throw new IllegalArgumentException("negative index " + position);
        }
        if (position >= limit) {
            throw new IllegalArgumentException("index too large " + position + ">=" + limit);
        }
    }

    static boolean getBit(int value, int position) {
        BitUtil.checkBounds(position, 32);
        return (value & 1 << position) != 0;
    }

    static boolean getBit(long value, int position) {
        BitUtil.checkBounds(position, 64);
        return (value & 1L << position) != 0L;
    }

    static int clearBit(int value, int position) {
        BitUtil.checkBounds(position, 32);
        return value & ~(1 << position);
    }

    static int setBit(int value, int position) {
        BitUtil.checkBounds(position, 32);
        return value | 1 << position;
    }

    static int setBitTo(int value, int position, boolean setTo) {
        if (setTo) {
            return BitUtil.setBit(value, position);
        }
        return BitUtil.clearBit(value, position);
    }

    private static int getMask(int start, int end) {
        BitUtil.checkBounds(start, 32);
        BitUtil.checkBounds(end, 32);
        if (start > end) {
            throw new IllegalArgumentException("start index exceeds end");
        }
        return (int)((1L << end + 1 - start) - 1L);
    }

    private static long getMaskLong(int start, int end) {
        BitUtil.checkBounds(start, 64);
        BitUtil.checkBounds(end, 64);
        if (start > end) {
            throw new IllegalArgumentException("start index exceeds end");
        }
        return (1L << end + 1 - start) - 1L;
    }

    static int getBits(int value, int start, int end) {
        int mask = BitUtil.getMask(start, end);
        return (value >>= start) & mask;
    }

    static long getBits(long value, int start, int end) {
        long mask = BitUtil.getMaskLong(start, end);
        return (value >>= start) & mask;
    }

    static int clearBits(int value, int start, int end) {
        int mask = BitUtil.getMask(start, end);
        return value & ~(mask << start);
    }

    static int setBitsTo(int value, int start, int end, int setTo) {
        value = BitUtil.clearBits(value, start, end);
        int mask = BitUtil.getMask(start, end);
        if (setTo != (setTo & mask)) {
            throw new IllegalArgumentException(Integer.toHexString(setTo) + " does not fit inside " + start + ":" + end);
        }
        return value | setTo << start;
    }
}

