/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.namenode.rpc.tcp;

import com.ibm.narpc.NaRPCServerChannel;
import com.ibm.narpc.NaRPCService;
import org.apache.crail.namenode.rpc.tcp.TcpNameNodeRequest;
import org.apache.crail.namenode.rpc.tcp.TcpNameNodeResponse;
import org.apache.crail.rpc.RpcErrors;
import org.apache.crail.rpc.RpcNameNodeService;
import org.apache.crail.rpc.RpcNameNodeState;
import org.apache.crail.rpc.RpcProtocol;
import org.apache.crail.utils.CrailUtils;
import org.slf4j.Logger;

public class TcpRpcDispatcher
implements NaRPCService<TcpNameNodeRequest, TcpNameNodeResponse> {
    public static final Logger LOG = CrailUtils.getLogger();
    private RpcNameNodeService service;

    public TcpRpcDispatcher(RpcNameNodeService service) {
        this.service = service;
    }

    public TcpNameNodeRequest createRequest() {
        return new TcpNameNodeRequest();
    }

    public TcpNameNodeResponse processRequest(TcpNameNodeRequest request) {
        TcpNameNodeResponse response = new TcpNameNodeResponse();
        short error = RpcErrors.ERR_OK;
        try {
            short type = RpcProtocol.responseTypes[request.getCmd()];
            response.setType(type);
            switch (request.getCmd()) {
                case 1: {
                    error = this.service.createFile(request.createFile(), response.createFile(), (RpcNameNodeState)response);
                    break;
                }
                case 2: {
                    error = this.service.getFile(request.getFile(), response.getFile(), (RpcNameNodeState)response);
                    break;
                }
                case 3: {
                    error = this.service.setFile(request.setFile(), response.getVoid(), (RpcNameNodeState)response);
                    break;
                }
                case 4: {
                    error = this.service.removeFile(request.removeFile(), response.removeFile(), (RpcNameNodeState)response);
                    break;
                }
                case 5: {
                    error = this.service.renameFile(request.renameFile(), response.renameFile(), (RpcNameNodeState)response);
                    break;
                }
                case 6: {
                    error = this.service.getBlock(request.getBlock(), response.getBlock(), (RpcNameNodeState)response);
                    break;
                }
                case 7: {
                    error = this.service.getLocation(request.getLocation(), response.getLocation(), (RpcNameNodeState)response);
                    break;
                }
                case 8: {
                    error = this.service.setBlock(request.setBlock(), response.getVoid(), (RpcNameNodeState)response);
                    break;
                }
                case 12: {
                    error = this.service.getDataNode(request.getDataNode(), response.getDataNode(), (RpcNameNodeState)response);
                    break;
                }
                case 10: {
                    error = this.service.dump(request.dumpNameNode(), response.getVoid(), (RpcNameNodeState)response);
                    break;
                }
                case 11: {
                    error = this.service.ping(request.pingNameNode(), response.pingNameNode(), (RpcNameNodeState)response);
                    break;
                }
                default: {
                    error = RpcErrors.ERR_INVALID_RPC_CMD;
                    LOG.info("Rpc command not valid, opcode " + request.getCmd());
                    break;
                }
            }
        }
        catch (Exception e) {
            error = RpcErrors.ERR_UNKNOWN;
            LOG.info(RpcErrors.messages[RpcErrors.ERR_UNKNOWN] + e.getMessage());
            e.printStackTrace();
        }
        try {
            response.setError(error);
        }
        catch (Exception e) {
            LOG.info("ERROR: RPC failed, messagesSend ");
            e.printStackTrace();
        }
        return response;
    }

    public void removeEndpoint(NaRPCServerChannel channel) {
    }

    public void addEndpoint(NaRPCServerChannel channel) {
    }
}

