/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.namenode.rpc.tcp;

import com.ibm.narpc.NaRPCEndpoint;
import com.ibm.narpc.NaRPCFuture;
import com.ibm.narpc.NaRPCMessage;
import java.io.IOException;
import org.apache.crail.CrailNodeType;
import org.apache.crail.metadata.BlockInfo;
import org.apache.crail.metadata.DataNodeInfo;
import org.apache.crail.metadata.FileInfo;
import org.apache.crail.metadata.FileName;
import org.apache.crail.namenode.rpc.tcp.TcpFuture;
import org.apache.crail.namenode.rpc.tcp.TcpNameNodeRequest;
import org.apache.crail.namenode.rpc.tcp.TcpNameNodeResponse;
import org.apache.crail.rpc.RpcConnection;
import org.apache.crail.rpc.RpcCreateFile;
import org.apache.crail.rpc.RpcDeleteFile;
import org.apache.crail.rpc.RpcFuture;
import org.apache.crail.rpc.RpcGetBlock;
import org.apache.crail.rpc.RpcGetDataNode;
import org.apache.crail.rpc.RpcGetFile;
import org.apache.crail.rpc.RpcGetLocation;
import org.apache.crail.rpc.RpcPing;
import org.apache.crail.rpc.RpcRenameFile;
import org.apache.crail.rpc.RpcRequestMessage;
import org.apache.crail.rpc.RpcResponseMessage;
import org.apache.crail.rpc.RpcVoid;
import org.apache.crail.utils.CrailUtils;
import org.slf4j.Logger;

public class TcpRpcConnection
implements RpcConnection {
    private static final Logger LOG = CrailUtils.getLogger();
    private NaRPCEndpoint<TcpNameNodeRequest, TcpNameNodeResponse> endpoint;

    public TcpRpcConnection(NaRPCEndpoint<TcpNameNodeRequest, TcpNameNodeResponse> endpoint) {
        this.endpoint = endpoint;
    }

    public String toString() {
        String address = "";
        try {
            address = this.endpoint.address();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return address;
    }

    public void close() throws IOException {
        this.endpoint.close();
    }

    public RpcFuture<RpcCreateFile> createFile(FileName fileName, CrailNodeType type, int storageAffinity, int locationAffinity, boolean enumerable) throws IOException {
        RpcRequestMessage.CreateFileReq req = new RpcRequestMessage.CreateFileReq(fileName, type, storageAffinity, locationAffinity, enumerable);
        RpcResponseMessage.CreateFileRes resp = new RpcResponseMessage.CreateFileRes();
        TcpNameNodeRequest request = new TcpNameNodeRequest(req);
        TcpNameNodeResponse response = new TcpNameNodeResponse(resp);
        request.setCommand((short)1);
        NaRPCFuture future = this.endpoint.issueRequest((NaRPCMessage)request, (NaRPCMessage)response);
        return new TcpFuture<RpcResponseMessage.CreateFileRes>((NaRPCFuture<TcpNameNodeRequest, TcpNameNodeResponse>)future, resp);
    }

    public RpcFuture<RpcGetFile> getFile(FileName fileName, boolean b) throws IOException {
        RpcRequestMessage.GetFileReq req = new RpcRequestMessage.GetFileReq(fileName, b);
        RpcResponseMessage.GetFileRes resp = new RpcResponseMessage.GetFileRes();
        TcpNameNodeRequest request = new TcpNameNodeRequest(req);
        TcpNameNodeResponse response = new TcpNameNodeResponse(resp);
        request.setCommand((short)2);
        NaRPCFuture future = this.endpoint.issueRequest((NaRPCMessage)request, (NaRPCMessage)response);
        return new TcpFuture<RpcResponseMessage.GetFileRes>((NaRPCFuture<TcpNameNodeRequest, TcpNameNodeResponse>)future, resp);
    }

    public RpcFuture<RpcVoid> setFile(FileInfo fileInfo, boolean b) throws IOException {
        RpcRequestMessage.SetFileReq req = new RpcRequestMessage.SetFileReq(fileInfo, b);
        RpcResponseMessage.VoidRes resp = new RpcResponseMessage.VoidRes();
        TcpNameNodeRequest request = new TcpNameNodeRequest(req);
        TcpNameNodeResponse response = new TcpNameNodeResponse(resp);
        request.setCommand((short)3);
        NaRPCFuture future = this.endpoint.issueRequest((NaRPCMessage)request, (NaRPCMessage)response);
        return new TcpFuture<RpcResponseMessage.VoidRes>((NaRPCFuture<TcpNameNodeRequest, TcpNameNodeResponse>)future, resp);
    }

    public RpcFuture<RpcDeleteFile> removeFile(FileName fileName, boolean b) throws IOException {
        RpcRequestMessage.RemoveFileReq req = new RpcRequestMessage.RemoveFileReq(fileName, b);
        RpcResponseMessage.DeleteFileRes resp = new RpcResponseMessage.DeleteFileRes();
        TcpNameNodeRequest request = new TcpNameNodeRequest(req);
        TcpNameNodeResponse response = new TcpNameNodeResponse(resp);
        request.setCommand((short)4);
        NaRPCFuture future = this.endpoint.issueRequest((NaRPCMessage)request, (NaRPCMessage)response);
        return new TcpFuture<RpcResponseMessage.DeleteFileRes>((NaRPCFuture<TcpNameNodeRequest, TcpNameNodeResponse>)future, resp);
    }

    public RpcFuture<RpcRenameFile> renameFile(FileName fileName, FileName fileName1) throws IOException {
        RpcRequestMessage.RenameFileReq req = new RpcRequestMessage.RenameFileReq(fileName, fileName1);
        RpcResponseMessage.RenameRes resp = new RpcResponseMessage.RenameRes();
        TcpNameNodeRequest request = new TcpNameNodeRequest(req);
        TcpNameNodeResponse response = new TcpNameNodeResponse(resp);
        request.setCommand((short)5);
        NaRPCFuture future = this.endpoint.issueRequest((NaRPCMessage)request, (NaRPCMessage)response);
        return new TcpFuture<RpcResponseMessage.RenameRes>((NaRPCFuture<TcpNameNodeRequest, TcpNameNodeResponse>)future, resp);
    }

    public RpcFuture<RpcGetBlock> getBlock(long fd, long token, long position, long capacity) throws IOException {
        RpcRequestMessage.GetBlockReq req = new RpcRequestMessage.GetBlockReq(fd, token, position, capacity);
        RpcResponseMessage.GetBlockRes resp = new RpcResponseMessage.GetBlockRes();
        TcpNameNodeRequest request = new TcpNameNodeRequest(req);
        TcpNameNodeResponse response = new TcpNameNodeResponse(resp);
        request.setCommand((short)6);
        NaRPCFuture future = this.endpoint.issueRequest((NaRPCMessage)request, (NaRPCMessage)response);
        return new TcpFuture<RpcResponseMessage.GetBlockRes>((NaRPCFuture<TcpNameNodeRequest, TcpNameNodeResponse>)future, resp);
    }

    public RpcFuture<RpcGetLocation> getLocation(FileName fileName, long l) throws IOException {
        RpcRequestMessage.GetLocationReq req = new RpcRequestMessage.GetLocationReq(fileName, l);
        RpcResponseMessage.GetLocationRes resp = new RpcResponseMessage.GetLocationRes();
        TcpNameNodeRequest request = new TcpNameNodeRequest(req);
        TcpNameNodeResponse response = new TcpNameNodeResponse(resp);
        request.setCommand((short)7);
        NaRPCFuture future = this.endpoint.issueRequest((NaRPCMessage)request, (NaRPCMessage)response);
        return new TcpFuture<RpcResponseMessage.GetLocationRes>((NaRPCFuture<TcpNameNodeRequest, TcpNameNodeResponse>)future, resp);
    }

    public RpcFuture<RpcVoid> setBlock(BlockInfo blockInfo) throws Exception {
        RpcRequestMessage.SetBlockReq req = new RpcRequestMessage.SetBlockReq(blockInfo);
        RpcResponseMessage.VoidRes resp = new RpcResponseMessage.VoidRes();
        TcpNameNodeRequest request = new TcpNameNodeRequest(req);
        TcpNameNodeResponse response = new TcpNameNodeResponse(resp);
        request.setCommand((short)8);
        NaRPCFuture future = this.endpoint.issueRequest((NaRPCMessage)request, (NaRPCMessage)response);
        return new TcpFuture<RpcResponseMessage.VoidRes>((NaRPCFuture<TcpNameNodeRequest, TcpNameNodeResponse>)future, resp);
    }

    public RpcFuture<RpcGetDataNode> getDataNode(DataNodeInfo dataNodeInfo) throws Exception {
        RpcRequestMessage.GetDataNodeReq req = new RpcRequestMessage.GetDataNodeReq(dataNodeInfo);
        RpcResponseMessage.GetDataNodeRes resp = new RpcResponseMessage.GetDataNodeRes();
        TcpNameNodeRequest request = new TcpNameNodeRequest(req);
        TcpNameNodeResponse response = new TcpNameNodeResponse(resp);
        request.setCommand((short)12);
        NaRPCFuture future = this.endpoint.issueRequest((NaRPCMessage)request, (NaRPCMessage)response);
        return new TcpFuture<RpcResponseMessage.GetDataNodeRes>((NaRPCFuture<TcpNameNodeRequest, TcpNameNodeResponse>)future, resp);
    }

    public RpcFuture<RpcVoid> dumpNameNode() throws Exception {
        RpcRequestMessage.DumpNameNodeReq req = new RpcRequestMessage.DumpNameNodeReq();
        RpcResponseMessage.VoidRes resp = new RpcResponseMessage.VoidRes();
        TcpNameNodeRequest request = new TcpNameNodeRequest(req);
        TcpNameNodeResponse response = new TcpNameNodeResponse(resp);
        request.setCommand((short)10);
        NaRPCFuture future = this.endpoint.issueRequest((NaRPCMessage)request, (NaRPCMessage)response);
        return new TcpFuture<RpcResponseMessage.VoidRes>((NaRPCFuture<TcpNameNodeRequest, TcpNameNodeResponse>)future, resp);
    }

    public RpcFuture<RpcPing> pingNameNode() throws Exception {
        RpcRequestMessage.PingNameNodeReq req = new RpcRequestMessage.PingNameNodeReq();
        RpcResponseMessage.PingNameNodeRes resp = new RpcResponseMessage.PingNameNodeRes();
        TcpNameNodeRequest request = new TcpNameNodeRequest(req);
        TcpNameNodeResponse response = new TcpNameNodeResponse(resp);
        request.setCommand((short)11);
        NaRPCFuture future = this.endpoint.issueRequest((NaRPCMessage)request, (NaRPCMessage)response);
        return new TcpFuture<RpcResponseMessage.PingNameNodeRes>((NaRPCFuture<TcpNameNodeRequest, TcpNameNodeResponse>)future, resp);
    }
}

