/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.namenode.rpc.tcp;

import com.ibm.narpc.NaRPCClientGroup;
import com.ibm.narpc.NaRPCEndpoint;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import org.apache.crail.conf.CrailConfiguration;
import org.apache.crail.namenode.rpc.tcp.TcpNameNodeRequest;
import org.apache.crail.namenode.rpc.tcp.TcpNameNodeResponse;
import org.apache.crail.namenode.rpc.tcp.TcpRpcConnection;
import org.apache.crail.namenode.rpc.tcp.TcpRpcConstants;
import org.apache.crail.rpc.RpcClient;
import org.apache.crail.rpc.RpcConnection;
import org.slf4j.Logger;

public class TcpNameNodeClient
implements RpcClient {
    private NaRPCClientGroup<TcpNameNodeRequest, TcpNameNodeResponse> clientGroup;
    private LinkedList<TcpRpcConnection> allConnections;

    public void init(CrailConfiguration conf, String[] strings) throws IOException {
        try {
            TcpRpcConstants.updateConstants(conf);
            TcpRpcConstants.verify();
            this.clientGroup = new NaRPCClientGroup(TcpRpcConstants.NAMENODE_TCP_QUEUEDEPTH, TcpRpcConstants.NAMENODE_TCP_MESSAGESIZE, true);
            this.allConnections = new LinkedList();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void printConf(Logger logger) {
        TcpRpcConstants.printConf(logger);
    }

    public RpcConnection connect(InetSocketAddress address) throws IOException {
        try {
            NaRPCEndpoint endpoint = this.clientGroup.createEndpoint();
            endpoint.connect(address);
            TcpRpcConnection connection = new TcpRpcConnection((NaRPCEndpoint<TcpNameNodeRequest, TcpNameNodeResponse>)endpoint);
            this.allConnections.add(connection);
            return connection;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void close() {
        try {
            for (TcpRpcConnection connection : this.allConnections) {
                connection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

