/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.narpc;

import com.ibm.narpc.NaRPCDispatcher;
import com.ibm.narpc.NaRPCGroup;
import com.ibm.narpc.NaRPCMessage;
import com.ibm.narpc.NaRPCServerChannel;
import com.ibm.narpc.NaRPCServerEndpoint;
import com.ibm.narpc.NaRPCService;
import com.ibm.narpc.NaRPCUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NaRPCServerGroup<R extends NaRPCMessage, T extends NaRPCMessage>
extends NaRPCGroup {
    private static final Logger LOG = NaRPCUtils.getLogger();
    public static final int DEFAULT_DISPATCHARRAY = 1;
    private ArrayList<NaRPCDispatcher<R, T>> dispatcherArray;
    private AtomicInteger arrayIndex;

    public NaRPCServerGroup(NaRPCService<R, T> service) throws IOException {
        this(service, NaRPCGroup.DEFAULT_QUEUE_DEPTH, NaRPCGroup.DEFAULT_MESSAGE_SIZE, NaRPCGroup.DEFAULT_NODELAY, 1);
    }

    public NaRPCServerGroup(NaRPCService<R, T> service, int queueDepth, int messageSize, boolean nodelay) throws IOException {
        this(service, queueDepth, messageSize, nodelay, 1);
    }

    public NaRPCServerGroup(NaRPCService<R, T> service, int queueDepth, int messageSize, boolean nodelay, int arraySize) throws IOException {
        super(queueDepth, messageSize, nodelay);
        this.dispatcherArray = new ArrayList(arraySize);
        for (int i = 0; i < arraySize; ++i) {
            NaRPCDispatcher<R, T> dispatcher = new NaRPCDispatcher<R, T>(this, service, i);
            Thread thread = new Thread(dispatcher);
            thread.start();
            this.dispatcherArray.add(dispatcher);
        }
        this.arrayIndex = new AtomicInteger(0);
        LOG.info("new NaRPC server group v1.5.0, queueDepth " + this.getQueueDepth() + ", messageSize " + this.getMessageSize() + ", nodealy " + this.isNodelay() + ", cores " + arraySize);
    }

    public NaRPCServerEndpoint<R, T> createServerEndpoint() throws IOException {
        return new NaRPCServerEndpoint(this);
    }

    public void registerEndpoint(NaRPCServerChannel endpoint) throws IOException {
        int index = this.getAndIncrement() % this.dispatcherArray.size();
        NaRPCDispatcher<R, T> dispatcher = this.dispatcherArray.get(index);
        dispatcher.addChannel(endpoint);
    }

    public void close() throws IOException {
        for (int i = 0; i < this.dispatcherArray.size(); ++i) {
            this.dispatcherArray.get(i).close();
        }
    }

    private int getAndIncrement() {
        return this.arrayIndex.getAndIncrement() & Integer.MAX_VALUE;
    }
}

