/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.narpc;

import com.ibm.narpc.NaRPCMessage;
import com.ibm.narpc.NaRPCServerChannel;
import com.ibm.narpc.NaRPCServerGroup;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NaRPCServerEndpoint<R extends NaRPCMessage, T extends NaRPCMessage> {
    private NaRPCServerGroup<R, T> serverGroup;
    private ServerSocketChannel serverSocket;

    public NaRPCServerEndpoint(NaRPCServerGroup<R, T> serverGroup) throws IOException {
        this.serverGroup = serverGroup;
        this.serverSocket = ServerSocketChannel.open();
        this.serverSocket.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
    }

    public NaRPCServerChannel accept() throws Exception {
        SocketChannel channel = this.serverSocket.accept();
        NaRPCServerChannel serverChannel = new NaRPCServerChannel(this.serverGroup, channel);
        this.serverGroup.registerEndpoint(serverChannel);
        return serverChannel;
    }

    public void close() throws Exception {
        this.serverSocket.close();
    }

    public NaRPCServerEndpoint<R, T> bind(InetSocketAddress address) throws IOException {
        this.serverSocket.bind(address);
        return this;
    }

    public String address() throws IOException {
        return this.serverSocket.getLocalAddress().toString();
    }
}

