/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.narpc;

import com.ibm.narpc.NaRPCGroup;
import com.ibm.narpc.NaRPCMessage;
import com.ibm.narpc.NaRPCProtocol;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class NaRPCServerChannel {
    private SocketChannel channel;
    private ByteBuffer buffer;

    public NaRPCServerChannel(NaRPCGroup group, SocketChannel channel) {
        this.channel = channel;
        this.buffer = ByteBuffer.allocate(group.getMessageSize());
    }

    public long receiveMessage(NaRPCMessage message) throws IOException {
        long ticket = NaRPCProtocol.fetchBuffer(this.channel, this.buffer);
        while (ticket == 0L) {
            ticket = NaRPCProtocol.fetchBuffer(this.channel, this.buffer);
        }
        if (ticket > 0L) {
            message.update(this.buffer);
        }
        return ticket;
    }

    public void transmitMessage(long ticket, NaRPCMessage message) throws IOException {
        NaRPCProtocol.makeMessage(ticket, message, this.buffer);
        while (this.buffer.hasRemaining()) {
            this.channel.write(this.buffer);
        }
    }

    public void close() throws IOException {
        this.channel.close();
    }

    public SocketChannel getSocketChannel() {
        return this.channel;
    }

    public String address() throws IOException {
        return this.channel.getRemoteAddress().toString();
    }
}

