/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.narpc;

import com.ibm.narpc.NaRPCMessage;
import com.ibm.narpc.NaRPCUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.slf4j.Logger;

public class NaRPCProtocol {
    public static final int HEADERSIZE = 12;
    private static final Logger LOG = NaRPCUtils.getLogger();

    public static void makeMessage(long ticket, NaRPCMessage message, ByteBuffer buffer) throws IOException {
        buffer.clear().position(12);
        int size = message.write(buffer);
        buffer.flip();
        if (size + 12 != buffer.remaining()) {
            throw new IOException("Error in serialization");
        }
        buffer.clear();
        buffer.putInt(size);
        buffer.putLong(ticket);
        buffer.clear().limit(12 + size);
    }

    public static long fetchBuffer(SocketChannel channel, ByteBuffer buffer) throws IOException {
        buffer.clear().limit(12);
        int ret = channel.read(buffer);
        if (ret <= 0) {
            return ret;
        }
        while (buffer.hasRemaining()) {
            if (channel.read(buffer) >= 0) continue;
            return -1L;
        }
        buffer.flip();
        int size = buffer.getInt();
        long ticket = buffer.getLong();
        buffer.clear().limit(size);
        while (buffer.hasRemaining()) {
            if (channel.read(buffer) >= 0) continue;
            throw new IOException("error when reading header from socket");
        }
        buffer.flip();
        return ticket;
    }
}

