/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.narpc;

import com.ibm.narpc.NaRPCEndpoint;
import com.ibm.narpc.NaRPCMessage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NaRPCFuture<R extends NaRPCMessage, T extends NaRPCMessage>
implements Future<T> {
    private NaRPCEndpoint<R, T> endpoint;
    private R request;
    private T response;
    private long ticket;
    private AtomicBoolean done;

    public NaRPCFuture(NaRPCEndpoint<R, T> endpoint, R request, T response, long ticket) {
        this.endpoint = endpoint;
        this.request = request;
        this.response = response;
        this.ticket = ticket;
        this.done = new AtomicBoolean(false);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        try {
            if (!this.done.get()) {
                this.endpoint.pollResponse();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.done.get();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        try {
            while (!this.done.get()) {
                this.endpoint.pollResponse();
            }
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
        return this.response;
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            while (!this.done.get()) {
                this.endpoint.pollResponse();
            }
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
        return this.response;
    }

    public R getRequest() {
        return this.request;
    }

    public T getResponse() {
        return this.response;
    }

    public long getTicket() {
        return this.ticket;
    }

    void signal() {
        this.done.set(true);
    }
}

