/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.narpc;

import com.ibm.narpc.NaRPCFuture;
import com.ibm.narpc.NaRPCGroup;
import com.ibm.narpc.NaRPCMessage;
import com.ibm.narpc.NaRPCProtocol;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NaRPCEndpoint<R extends NaRPCMessage, T extends NaRPCMessage> {
    private NaRPCGroup group;
    private ConcurrentHashMap<Long, NaRPCFuture<R, T>> pendingRPCs;
    private ArrayBlockingQueue<ByteBuffer> bufferQueue;
    private AtomicLong sequencer;
    private SocketChannel channel;
    private ReentrantLock readLock;
    private ReentrantLock writeLock;

    public NaRPCEndpoint(NaRPCGroup group, SocketChannel channel) throws Exception {
        this.group = group;
        this.channel = channel;
        this.channel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)group.isNodelay());
        this.channel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
        this.pendingRPCs = new ConcurrentHashMap();
        this.bufferQueue = new ArrayBlockingQueue(group.getQueueDepth());
        for (int i = 0; i < group.getQueueDepth(); ++i) {
            ByteBuffer reqBuffer = ByteBuffer.allocate(group.getMessageSize());
            this.bufferQueue.put(reqBuffer);
        }
        this.sequencer = new AtomicLong(1L);
        this.readLock = new ReentrantLock();
        this.writeLock = new ReentrantLock();
    }

    public void connect(InetSocketAddress address) throws IOException {
        this.channel.configureBlocking(false);
        this.channel.connect(address);
        while (!this.channel.finishConnect()) {
        }
    }

    public void close() throws IOException {
        this.channel.close();
    }

    public NaRPCFuture<R, T> issueRequest(R request, T response) throws IOException {
        ByteBuffer buffer = this.getBuffer();
        while (buffer == null) {
            buffer = this.getBuffer();
        }
        long ticket = this.sequencer.getAndIncrement();
        NaRPCProtocol.makeMessage(ticket, request, buffer);
        NaRPCFuture<R, T> future = new NaRPCFuture<R, T>(this, request, response, ticket);
        this.pendingRPCs.put(ticket, future);
        while (!this.writeLock.tryLock()) {
        }
        this.channel.write(buffer);
        while (buffer.hasRemaining()) {
            this.pollResponse();
            this.channel.write(buffer);
        }
        this.writeLock.unlock();
        this.putBuffer(buffer);
        return future;
    }

    void pollResponse() throws IOException {
        ByteBuffer buffer = this.getBuffer();
        if (buffer == null) {
            return;
        }
        if (this.readLock.tryLock()) {
            long ticket = NaRPCProtocol.fetchBuffer(this.channel, buffer);
            this.readLock.unlock();
            if (ticket > 0L) {
                NaRPCFuture<R, T> future = this.pendingRPCs.remove(ticket);
                future.getResponse().update(buffer);
                future.signal();
            }
        }
        this.putBuffer(buffer);
    }

    public String address() throws IOException {
        return this.channel.getRemoteAddress().toString();
    }

    private ByteBuffer getBuffer() {
        ByteBuffer buffer = this.bufferQueue.poll();
        return buffer;
    }

    private void putBuffer(ByteBuffer buffer) throws IOException {
        try {
            this.bufferQueue.put(buffer);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }
}

